/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.service.ErrorService;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLParsingUtils {
    private static final Log LOG = LogFactory.getLog(XMLParsingUtils.class);
    private static final String XML_START = "<?xml";
    private static ThreadLocal<LimeParser> _parserContainer = new ThreadLocal<LimeParser>(){

        @Override
        protected LimeParser initialValue() {
            return new LimeParser();
        }
    };

    public static ParseResult parse(String xml, int responseCount) throws IOException, SAXException {
        xml = LimeXMLUtils.scanForBadCharacters(xml);
        return XMLParsingUtils.parse(new InputSource(new StringReader(xml)), responseCount);
    }

    public static ParseResult parse(InputSource inputSource) throws IOException, SAXException {
        return XMLParsingUtils.parse(inputSource, 8);
    }

    public static ParseResult parse(InputSource inputSource, int responseCount) throws IOException, SAXException {
        ParseResult result = new ParseResult(responseCount);
        LimeParser parser = _parserContainer.get();
        parser.parse(result, inputSource);
        return result;
    }

    public static List<String> split(String aggregatedXmlDocuments) {
        ArrayList<String> results = new ArrayList<String>();
        int begin = aggregatedXmlDocuments.indexOf(XML_START);
        int end = aggregatedXmlDocuments.indexOf(XML_START, begin + 1);
        while (end != -1) {
            results.add(aggregatedXmlDocuments.substring(begin, end));
            begin = end;
            end = aggregatedXmlDocuments.indexOf(XML_START, begin + 1);
        }
        if (begin != -1) {
            results.add(aggregatedXmlDocuments.substring(begin));
        }
        return results;
    }

    private static class LimeParser
    extends DefaultHandler {
        private final XMLReader _reader;
        private ParseResult _result;
        boolean _isFirstElement = true;

        LimeParser() {
            XMLReader reader;
            try {
                reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                reader.setContentHandler(this);
                reader.setErrorHandler(this);
                reader.setFeature("http://xml.org/sax/features/namespaces", false);
            }
            catch (SAXException bad) {
                ErrorService.error(bad);
                reader = null;
            }
            catch (ParserConfigurationException bad) {
                ErrorService.error(bad);
                reader = null;
            }
            this._reader = reader;
        }

        public void parse(ParseResult dest, InputSource input) throws SAXException, IOException {
            if (this._reader == null) {
                return;
            }
            this._isFirstElement = true;
            this._result = dest;
            this._reader.parse(input);
        }

        public void startElement(String namespaceUri, String localName, String qualifiedName, Attributes attributes) {
            if (this._isFirstElement) {
                this._isFirstElement = false;
                this._result.canonicalKeyPrefix = qualifiedName;
                return;
            }
            if (this._result.type == null) {
                this._result.type = qualifiedName;
                this._result.schemaURI = "http://www.limewire.com/schemas/" + this._result.type + ".xsd";
                this._result.canonicalKeyPrefix = this._result.canonicalKeyPrefix + "__" + qualifiedName + "__";
            }
            int attributesLength = attributes.getLength();
            this._result.canonicalKeyPrefix = this._result.canonicalKeyPrefix.toLowerCase(Locale.US);
            if (attributesLength > 0) {
                HashMap<String, String> attributeMap = new HashMap<String, String>(attributesLength);
                for (int i = 0; i < attributesLength; ++i) {
                    String qName = attributes.getQName(i).toLowerCase(Locale.US);
                    attributeMap.put(this._result.canonicalKeyPrefix + qName + "__", attributes.getValue(i).trim());
                }
                this._result.add(attributeMap);
            } else {
                Map empty = Collections.emptyMap();
                this._result.add(empty);
            }
        }

        public void fatalError(SAXParseException e) throws SAXException {
            LOG.fatal("Fatal parsing error", e);
            throw e;
        }

        public void warning(SAXParseException e) throws SAXException {
            LOG.warn("parse warning", e);
        }

        public void error(SAXParseException e) throws SAXException {
            LOG.error("Parsing error", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParseResult
    extends ArrayList<Map<String, String>> {
        public String schemaURI;
        public String type;
        public String canonicalKeyPrefix;

        public ParseResult(int size) {
            super(size * 2 / 3);
        }
    }
}

