/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import org.limewire.collection.BitField;
import org.limewire.collection.BitSet;

public class BitFieldSet
implements BitField {
    private final int maxSize;
    private final BitSet bs;

    public BitFieldSet(BitSet bs, int maxSize) {
        this.bs = bs;
        this.maxSize = maxSize;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int cardinality() {
        if (this.bs.length() <= this.maxSize) {
            return this.bs.cardinality();
        }
        return this.bs.get(0, this.maxSize).cardinality();
    }

    public boolean get(int i) {
        if (i > this.maxSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.bs.get(i);
    }

    public int nextClearBit(int i) {
        int ret = this.bs.nextClearBit(i);
        return ret >= this.maxSize ? -1 : ret;
    }

    public int nextSetBit(int i) {
        int ret = this.bs.nextSetBit(i);
        return ret >= this.maxSize ? -1 : ret;
    }
}

