/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import org.limewire.collection.BitField;

abstract class BooleanFunction
implements BitField {
    protected final BitField[] fields;

    protected BooleanFunction(BitField first, BitField ... more) {
        this.fields = new BitField[more.length + 1];
        this.fields[0] = first;
        System.arraycopy(more, 0, this.fields, 1, more.length);
        int maxSize = this.fields[0].maxSize();
        for (BitField bf : this.fields) {
            if (bf.maxSize() == maxSize) continue;
            throw new IllegalArgumentException("bitfield " + bf + " doesn't have size " + maxSize);
        }
    }

    public int maxSize() {
        return this.fields[0].maxSize();
    }

    public int cardinality() {
        int ret = 0;
        for (int i = 0; i < this.maxSize(); ++i) {
            ret += this.get(i) ? 1 : 0;
        }
        return ret;
    }
}

