/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import org.limewire.collection.PatriciaTrie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharSequenceKeyAnalyzer
implements PatriciaTrie.KeyAnalyzer<CharSequence> {
    private static final long serialVersionUID = -7032449491269434877L;
    private static final int[] BITS = CharSequenceKeyAnalyzer.createIntBitMask(16);

    public static final int[] createIntBitMask(int bitCount) {
        int[] bits = new int[bitCount];
        for (int i = 0; i < bitCount; ++i) {
            bits[i] = 1 << bitCount - i - 1;
        }
        return bits;
    }

    @Override
    public int length(CharSequence key) {
        return key != null ? key.length() * 16 : 0;
    }

    @Override
    public int bitIndex(CharSequence key, int keyOff, int keyLength, CharSequence found, int foundOff, int foundKeyLength) {
        boolean allNull = true;
        if (keyOff % 16 != 0 || foundOff % 16 != 0 || keyLength % 16 != 0 || foundKeyLength % 16 != 0) {
            throw new IllegalArgumentException("offsets & lengths must be at character boundaries");
        }
        int off1 = keyOff / 16;
        int off2 = foundOff / 16;
        int len1 = keyLength / 16 + off1;
        int len2 = foundKeyLength / 16 + off2;
        int length = Math.max(len1, len2);
        char k = '\u0000';
        char f = '\u0000';
        for (int i = 0; i < length; ++i) {
            int kOff = i + off1;
            int fOff = i + off2;
            k = kOff >= len1 ? (char)'\u0000' : key.charAt(kOff);
            if (k != (f = found == null || fOff >= len2 ? (char)'\u0000' : found.charAt(fOff))) {
                int x = k ^ f;
                return i * 16 + (Integer.numberOfLeadingZeros(x) - 16);
            }
            if (k == '\u0000') continue;
            allNull = false;
        }
        if (allNull) {
            return -1;
        }
        return -2;
    }

    @Override
    public boolean isBitSet(CharSequence key, int keyLength, int bitIndex) {
        if (key == null || bitIndex >= keyLength) {
            return false;
        }
        int index = bitIndex / BITS.length;
        int bit = bitIndex - index * BITS.length;
        return (key.charAt(index) & BITS[bit]) != 0;
    }

    @Override
    public int compare(CharSequence o1, CharSequence o2) {
        return ((Object)o1).toString().compareTo(((Object)o2).toString());
    }

    @Override
    public int bitsPerElement() {
        return 16;
    }

    @Override
    public boolean isPrefix(CharSequence prefix, int offset, int length, CharSequence key) {
        if (offset % 16 != 0 || length % 16 != 0) {
            throw new IllegalArgumentException("Cannot determine prefix outside of character boundaries");
        }
        String s1 = ((Object)prefix.subSequence(offset / 16, length / 16)).toString();
        String s2 = ((Object)key).toString();
        return s2.startsWith(s1);
    }
}

