/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.io.File;
import java.io.Serializable;
import java.util.Comparator;
import org.limewire.collection.FileComparator;
import org.limewire.collection.StringComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Comparators {
    private static final Comparator<Integer> INT_COMPARATOR = new IntComparator();
    private static final Comparator<Integer> INVERSE_INT_COMPARATOR = new InverseIntComparator();
    private static final Comparator<Long> LONG_COMPARATOR = new LongComparator();
    private static final Comparator<Long> INVERSE_LONG_COMPARATOR = new InverseLongComparator();
    private static final Comparator<String> STRING_COMPARATOR = new StringComparator();
    private static final Comparator<File> FILE_COMPARATOR = new FileComparator();
    private static final Comparator<String> CASE_INSENSITIVE_STRING_COMPARATOR = new CaseInsensitiveStringComparator();
    private static final Comparator<Double> INVERSE_DOUBLE_COMPARATOR = new Comparator<Double>(){

        @Override
        public int compare(Double a, Double b) {
            return b.compareTo(a);
        }
    };

    private Comparators() {
    }

    public static Comparator<Integer> integerComparator() {
        return INT_COMPARATOR;
    }

    public static Comparator<Integer> inverseIntegerComparator() {
        return INVERSE_INT_COMPARATOR;
    }

    public static Comparator<Long> longComparator() {
        return LONG_COMPARATOR;
    }

    public static Comparator<Long> inverseLongComparator() {
        return INVERSE_LONG_COMPARATOR;
    }

    public static Comparator<Double> inverseDoubleComparator() {
        return INVERSE_DOUBLE_COMPARATOR;
    }

    public static Comparator<String> stringComparator() {
        return STRING_COMPARATOR;
    }

    public static Comparator<File> fileComparator() {
        return FILE_COMPARATOR;
    }

    public static <T extends Comparable<T>> Comparator<T> naturalComparator(Class<? extends T> clazz) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        };
    }

    public static Comparator<String> caseInsensitiveStringComparator() {
        return CASE_INSENSITIVE_STRING_COMPARATOR;
    }

    public static int intCompareTo(Integer thisInt, Integer anotherInt) {
        int anotherVal;
        int thisVal = thisInt;
        return thisVal < (anotherVal = anotherInt.intValue()) ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public static int longCompareTo(Long firstLong, Long secondLong) {
        long secondVal;
        long firstVal = firstLong;
        return firstVal < (secondVal = secondLong.longValue()) ? -1 : (firstVal == secondVal ? 0 : 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteArrayComparator
    implements Comparator<byte[]> {
        @Override
        public int compare(byte[] a, byte[] b) {
            for (int i = 0; i < a.length; ++i) {
                if (a[i] > b[i]) {
                    return 1;
                }
                if (a[i] >= b[i]) continue;
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CaseInsensitiveStringComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 263123571237995212L;

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InverseLongComparator
    implements Comparator<Long>,
    Serializable {
        private static final long serialVersionUID = 316426787496198051L;

        private InverseLongComparator() {
        }

        @Override
        public int compare(Long o1, Long o2) {
            return -Comparators.longCompareTo(o1, o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LongComparator
    implements Comparator<Long>,
    Serializable {
        private static final long serialVersionUID = 226428887996180051L;

        private LongComparator() {
        }

        @Override
        public int compare(Long o1, Long o2) {
            return Comparators.longCompareTo(o1, o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InverseIntComparator
    implements Comparator<Integer> {
        private InverseIntComparator() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return -Comparators.intCompareTo(o1, o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntComparator
    implements Comparator<Integer>,
    Serializable {
        private static final long serialVersionUID = 830281396810831681L;

        private IntComparator() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return Comparators.intCompareTo(o1, o2);
        }
    }
}

