/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.limewire.collection.Buffer;
import org.limewire.collection.RandomAccessMap;
import org.limewire.collection.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedSizeArrayHashMap<K, V>
extends HashMap<K, V>
implements RandomAccessMap<K, V> {
    private Buffer<Map.Entry<K, V>> buf;
    private volatile transient Set<Map.Entry<K, V>> entrySet = null;
    private volatile transient Set<K> keySet = null;
    private volatile transient Collection<V> values = null;

    public FixedSizeArrayHashMap(int maxCapacity) {
        this.buf = new Buffer(maxCapacity);
    }

    public FixedSizeArrayHashMap(int maxCapacity, Map<? extends K, ? extends V> m) {
        this.buf = new Buffer(maxCapacity);
        this.putAll(m);
    }

    public FixedSizeArrayHashMap(Map<? extends K, ? extends V> m) {
        this(m.size(), m);
    }

    public FixedSizeArrayHashMap(int maxCapacity, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.buf = new Buffer(maxCapacity);
    }

    public FixedSizeArrayHashMap(int maxCapacity, int initialCapacity) {
        super(initialCapacity);
        this.buf = new Buffer(maxCapacity);
    }

    @Override
    public Object clone() {
        FixedSizeArrayHashMap newSet = (FixedSizeArrayHashMap)super.clone();
        newSet.buf = this.buf.clone();
        return newSet;
    }

    @Override
    public void clear() {
        this.buf.clear();
        super.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public V getValueAt(int i) {
        return this.buf.get(i).getValue();
    }

    @Override
    public K getKeyAt(int i) {
        return this.buf.get(i).getKey();
    }

    @Override
    public Map.Entry<K, V> getEntryAt(int i) {
        return this.buf.get(i);
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("null key/value not supported!");
        }
        V existing = super.put(key, value);
        if (existing == null) {
            Map.Entry removed = this.buf.add(new FixedEntry<K, V>(key, value));
            if (removed != null) {
                Object removedValue = super.remove(removed.getKey());
                assert (removedValue == removed.getValue());
            }
        } else {
            FixedEntry<K, V> e = new FixedEntry<K, V>(key, value);
            boolean removed = this.buf.remove(e);
            assert (removed);
            FixedEntry<K, V> ejected = this.buf.add(e);
            assert (ejected == null);
        }
        return existing;
    }

    @Override
    public V remove(Object key) {
        Object removed = super.remove(key);
        if (removed != null) {
            boolean success = this.buf.remove(new FixedEntry(key, removed));
            assert (success);
        }
        return removed;
    }

    protected Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new ArrayHashMapEntryIterator();
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        private Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = FixedSizeArrayHashMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public K next() {
                            return this.i.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return FixedSizeArrayHashMap.this.size();
                }

                @Override
                public boolean contains(Object k) {
                    return FixedSizeArrayHashMap.this.containsKey(k);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = FixedSizeArrayHashMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return FixedSizeArrayHashMap.this.size();
                }

                @Override
                public boolean contains(Object v) {
                    return FixedSizeArrayHashMap.this.containsValue(v);
                }
            };
        }
        return this.values;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return FixedSizeArrayHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value = e.getValue();
            return FixedSizeArrayHashMap.this.containsKey(key) && FixedSizeArrayHashMap.this.get(key).equals(value);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return FixedSizeArrayHashMap.this.size();
        }

        @Override
        public void clear() {
            FixedSizeArrayHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayHashMapEntryIterator
    extends UnmodifiableIterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> iter;
        private Map.Entry<K, V> current;

        private ArrayHashMapEntryIterator() {
            this.iter = FixedSizeArrayHashMap.this.buf.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.iter.next();
            return this.current;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        FixedEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            FixedEntry e = (FixedEntry)obj;
            return this.key.equals(e.key) && this.value.equals(e.value);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

