/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.limewire.collection.FixedSizeArrayHashMap;
import org.limewire.collection.RandomAccessCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedSizeArrayHashSet<E>
extends HashSet<E>
implements RandomAccessCollection<E> {
    private transient FixedSizeArrayHashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public FixedSizeArrayHashSet(int maxCapacity) {
        this.map = new FixedSizeArrayHashMap(maxCapacity);
    }

    public FixedSizeArrayHashSet(Collection<? extends E> c) {
        this(c.size());
        this.addAll(c);
    }

    public FixedSizeArrayHashSet(int maxCapacity, Collection<? extends E> c) {
        this(maxCapacity);
        this.addAll(c);
    }

    public FixedSizeArrayHashSet(int maxCapacity, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.map = new FixedSizeArrayHashMap(maxCapacity);
    }

    public FixedSizeArrayHashSet(int maxCapacity, int initialCapacity) {
        super(initialCapacity);
        this.map = new FixedSizeArrayHashMap(maxCapacity);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Object clone() {
        FixedSizeArrayHashSet newSet = (FixedSizeArrayHashSet)super.clone();
        newSet.map = (FixedSizeArrayHashMap)this.map.clone();
        return newSet;
    }

    @Override
    public E get(int i) {
        return this.map.getKeyAt(i);
    }
}

