/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.limewire.collection.SortedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedsizePriorityQueue<E>
implements Iterable<E> {
    private SortedList<E> tree;
    private int capacity;

    public FixedsizePriorityQueue(Comparator<? super E> comparator, int capacity) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.tree = new SortedList<E>(comparator);
        this.capacity = capacity;
    }

    public void clear() {
        this.tree.clear();
    }

    public boolean isFull() {
        return this.size() >= this.capacity();
    }

    public E insert(E x) {
        if (!this.isFull()) {
            boolean added = this.tree.add(x);
            assert (added);
            return null;
        }
        E smallest = this.tree.first();
        if (this.tree.comparator().compare(x, smallest) > 0) {
            this.tree.remove(smallest);
            boolean added = this.tree.add(x);
            assert (added);
            return smallest;
        }
        return x;
    }

    public E extractMax() {
        E e = this.getMax();
        this.remove(e);
        return e;
    }

    public E getMax() throws NoSuchElementException {
        return this.tree.last();
    }

    public E getMin() throws NoSuchElementException {
        return this.tree.first();
    }

    public boolean contains(Object o) {
        return this.tree.contains(o);
    }

    public boolean remove(Object o) {
        return this.tree.remove(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.tree.iterator();
    }

    public int size() {
        return this.tree.size();
    }

    public int capacity() {
        return this.capacity;
    }

    public String toString() {
        return this.tree.toString();
    }
}

