/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForgetfulHashMap<K, V>
extends HashMap<K, V> {
    private Object[] queue;
    private int next;
    private int n;

    public ForgetfulHashMap(int size) {
        if (size < 1) {
            throw new IllegalArgumentException();
        }
        this.queue = new Object[size];
        this.next = 0;
        this.n = size;
    }

    @Override
    public V put(K key, V value) {
        V ret = super.put(key, value);
        if (this.queue[this.next] != null) {
            super.remove(this.queue[this.next]);
        }
        this.queue[this.next] = key;
        ++this.next;
        if (this.next >= this.n) {
            this.next = 0;
        }
        return ret;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }
}

