/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.io.Serializable;
import org.limewire.collection.Range;
import org.limewire.util.ByteUtils;

class Interval
extends Range
implements Serializable {
    static final long serialVersionUID = -2562093104400487554L;
    private final int low;
    private final int high;

    protected Interval(long low, long high) {
        if (high < low) {
            throw new IllegalArgumentException("low: " + low + ", high: " + high);
        }
        if (low < 0L) {
            throw new IllegalArgumentException("low < min int:" + low);
        }
        if (high > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("high > max int:" + high);
        }
        this.low = (int)low;
        this.high = (int)high;
    }

    protected Interval(long singleton) {
        if (singleton < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("singleton < min:" + singleton);
        }
        if (singleton > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("singleton > max int:" + singleton);
        }
        this.low = (int)singleton;
        this.high = (int)singleton;
    }

    public byte[] toBytes() {
        byte[] res = new byte[8];
        this.toBytes(res, 0);
        return res;
    }

    public void toBytes(byte[] dest, int offset) {
        ByteUtils.int2beb(this.low, dest, offset);
        ByteUtils.int2beb(this.high, dest, offset + 4);
    }

    public final long getLow() {
        return this.low;
    }

    public final long getHigh() {
        return this.high;
    }

    public final boolean isLong() {
        return false;
    }
}

