/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.limewire.collection.NodeGenerator;
import org.limewire.collection.Range;
import org.limewire.collection.TreeStorage;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalSet
implements Iterable<Range>,
Serializable {
    private static final long serialVersionUID = -7791242963023638684L;
    static final int LINEAR = 16;
    private static final long KB_BOUNDARY = 1023L;
    private final List<Range> intervals = new ArrayList<Range>();

    public static IntervalSet createSingletonSet(long lowBound, long highBound) {
        IntervalSet ret = new IntervalSet();
        ret.add(Range.createRange(lowBound, highBound));
        return ret;
    }

    public void add(Range addInterval) {
        if (this.intervals.isEmpty()) {
            this.intervals.add(addInterval);
            return;
        }
        long low = addInterval.getLow();
        long high = addInterval.getHigh();
        Range lower = null;
        Range higher = null;
        int start = this.narrowStart(addInterval)[0];
        Iterator<Range> iter = this.intervals.subList(start, this.intervals.size()).iterator();
        while (iter.hasNext()) {
            Range interval = iter.next();
            if (low <= interval.getLow() && interval.getHigh() <= high) {
                iter.remove();
                continue;
            }
            if (low >= interval.getLow() && interval.getHigh() >= high) {
                return;
            }
            if (low <= interval.getHigh() + 1L && interval.getLow() < low) {
                lower = interval;
            }
            if (interval.getLow() - 1L <= high && interval.getHigh() > high) {
                higher = interval;
            }
            if (higher == null && interval.getLow() <= high) continue;
            break;
        }
        if (lower == null && higher == null) {
            this.addImpl(Range.createRange(low, high));
        } else if (lower != null && higher != null) {
            this.removeImpl(higher);
            this.removeImpl(lower);
            this.addImpl(Range.createRange(lower.getLow(), higher.getHigh()));
        } else if (higher != null) {
            this.removeImpl(higher);
            this.addImpl(Range.createRange(low, higher.getHigh()));
        } else {
            assert (lower != null);
            this.removeImpl(lower);
            this.addImpl(Range.createRange(lower.getLow(), high));
        }
    }

    public void add(IntervalSet set) {
        for (Range interval : set) {
            this.add(interval);
        }
    }

    public void delete(Range deleteMe) {
        long low = deleteMe.getLow();
        long high = deleteMe.getHigh();
        Range lower = null;
        Range higher = null;
        int[] range = this.narrowRange(deleteMe);
        Iterator<Range> iter = this.intervals.subList(range[0], range[1]).iterator();
        while (iter.hasNext()) {
            Range interval = iter.next();
            if (interval.getHigh() >= low && interval.getLow() <= high) {
                iter.remove();
                if (interval.getHigh() <= high) {
                    if (interval.getLow() >= low) continue;
                    lower = Range.createRange(interval.getLow(), low - 1L);
                    continue;
                }
                if (interval.getLow() >= low) {
                    higher = Range.createRange(high + 1L, interval.getHigh());
                    break;
                }
                lower = Range.createRange(interval.getLow(), low - 1L);
                higher = Range.createRange(high + 1L, interval.getHigh());
                break;
            }
            if (interval.getLow() < high) continue;
            break;
        }
        if (lower != null) {
            this.add(lower);
        }
        if (higher != null) {
            this.add(higher);
        }
    }

    public void delete(IntervalSet set) {
        for (Range interval : set) {
            this.delete(interval);
        }
    }

    public Range getFirst() throws NoSuchElementException {
        if (this.intervals.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.intervals.get(0);
    }

    public Range getLast() throws NoSuchElementException {
        if (this.intervals.isEmpty()) {
            throw new NoSuchElementException();
        }
        Range ret = this.intervals.get(this.intervals.size() - 1);
        return ret;
    }

    public int getNumberOfIntervals() {
        return this.intervals.size();
    }

    public boolean contains(Range i) {
        int[] range = this.narrowStart(i);
        for (int j = range[0]; j < range[1]; ++j) {
            Range ours = this.intervals.get(j);
            if (ours.getLow() <= i.getLow() && ours.getHigh() >= i.getHigh()) {
                return true;
            }
            if (ours.getLow() > i.getHigh()) break;
        }
        return false;
    }

    private int[] narrowStart(Range i) {
        int size = this.intervals.size();
        if (size < 16) {
            return new int[]{0, size};
        }
        int point = Collections.binarySearch(this.intervals, i, IntervalComparator.INSTANCE);
        if (point < 0) {
            point = -(point + 1);
        }
        int low = Math.max(0, point - 1);
        int high = Math.min(size, point + 1);
        return new int[]{low, high};
    }

    private int[] narrowRange(Range i) {
        int b;
        int size = this.intervals.size();
        if (size < 16) {
            return new int[]{0, size};
        }
        int a = Collections.binarySearch(this.intervals, i, IntervalComparator.INSTANCE);
        if (a < 0) {
            a = -(a + 1);
        }
        if ((b = Collections.binarySearch(this.intervals, Range.createRange(i.getHigh(), i.getHigh()), IntervalComparator.INSTANCE)) < 0) {
            b = -(b + 1);
        }
        a = Math.max(0, a - 1);
        b = Math.min(size, b + 1);
        return new int[]{a, b};
    }

    public boolean containsAny(Range i) {
        long low = i.getLow();
        long high = i.getHigh();
        int[] range = this.narrowStart(i);
        for (int j = range[0]; j < range[1]; ++j) {
            Range interval = this.intervals.get(j);
            if (low <= interval.getLow() && interval.getHigh() <= high) {
                return true;
            }
            if (low >= interval.getLow() && interval.getHigh() >= high) {
                return true;
            }
            if (low <= interval.getHigh() + 1L && interval.getLow() < low) {
                return true;
            }
            if (interval.getLow() - 1L > high || interval.getHigh() <= high) continue;
            return true;
        }
        return false;
    }

    public List<Range> getOverlapIntervals(Range checkInterval) {
        ArrayList<Range> overlapBlocks = new ArrayList<Range>();
        long high = checkInterval.getHigh();
        long low = checkInterval.getLow();
        if (low > high) {
            return overlapBlocks;
        }
        int[] range = this.narrowRange(checkInterval);
        for (int j = range[0]; j < range[1]; ++j) {
            Range interval = this.intervals.get(j);
            if (low <= interval.getLow() && interval.getHigh() <= high) {
                overlapBlocks.add(interval);
                continue;
            }
            if (low <= interval.getHigh() && interval.getLow() < low) {
                overlapBlocks.add(Range.createRange(low, Math.min(high, interval.getHigh())));
            }
            if (interval.getLow() > high || interval.getHigh() <= high) continue;
            overlapBlocks.add(Range.createRange(Math.max(interval.getLow(), low), high));
        }
        return overlapBlocks;
    }

    public Iterator<Range> getAllIntervals() {
        return this.intervals.iterator();
    }

    @Override
    public Iterator<Range> iterator() {
        return this.intervals.iterator();
    }

    public List<Range> getAllIntervalsAsList() {
        return new ArrayList<Range>(this.intervals);
    }

    public long getSize() {
        long sum = 0L;
        for (Range block : this.intervals) {
            sum += block.getHigh() - block.getLow() + 1L;
        }
        return sum;
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public void clear() {
        this.intervals.clear();
    }

    public Collection<Integer> encode(long maxSize) {
        long numLeafs = IntervalSet.getNumLeafs(maxSize);
        TreeStorage ts = new TreeStorage(null, new NodeGenerator.NullGenerator(), (int)numLeafs);
        ts.setAllowUnverifiedUse(true);
        for (Range r : this.intervals) {
            if ((r = this.align(r, maxSize)) == null) continue;
            for (long i = r.getLow(); i <= r.getHigh(); i += 1024L) {
                int chunk = ts.fileToNodeId((int)(i >> 10));
                ts.add(chunk, null);
                ts.used(chunk);
            }
        }
        return ts.getUsedNodes();
    }

    private Range align(Range r, long maxSize) {
        long low = r.getLow();
        long high = r.getHigh();
        if (high != maxSize - 1L ? high - low < 1023L : high % 1024L > high - low) {
            return null;
        }
        if ((low & 0x3FFL) != 0L) {
            low = (low & 0xFFFFFFFFFFFFFC00L) + 1024L;
        }
        if (high != maxSize - 1L && (high + 1L & 0x3FFL) != 0L) {
            high = (high + 1L & 0xFFFFFFFFFFFFFC00L) - 1L;
        }
        if (low == r.getLow() && high == r.getHigh()) {
            return r;
        }
        if (high < low) {
            return null;
        }
        return Range.createRange(low, high);
    }

    public void decode(long maxSize, Integer ... id) {
        long numLeafs = IntervalSet.getNumLeafs(maxSize);
        TreeStorage ts = new TreeStorage(null, new NodeGenerator.NullGenerator(), (int)numLeafs);
        Integer[] arr$ = id;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i = arr$[i$];
            int[] nodes = ts.nodeToFileId(i);
            if (nodes == null) continue;
            Range r = Range.createRange((long)nodes[0] * 1024L, Math.min((long)(nodes[1] + 1) * 1024L - 1L, maxSize - 1L));
            this.add(r);
        }
    }

    private static int getNumLeafs(long size) {
        long numLeafs = size >> 10;
        if (size % 1024L != 0L) {
            ++numLeafs;
        }
        assert (numLeafs <= Integer.MAX_VALUE);
        return (int)numLeafs;
    }

    public IntervalSet invert(long maxSize) {
        IntervalSet ret = new IntervalSet();
        if (maxSize < 1L) {
            return ret;
        }
        if (this.intervals.size() == 0) {
            Range block = Range.createRange(0L, maxSize - 1L);
            ret.add(block);
            return ret;
        }
        long low = -1L;
        Range interval = null;
        boolean fixed = false;
        Iterator<Range> iter = this.intervals.iterator();
        while (iter.hasNext()) {
            interval = iter.next();
            if (interval.getLow() != 0L && low < interval.getLow()) {
                if (low + 1L > interval.getLow() - 1L) {
                    if (!fixed) {
                        fixed = true;
                        this.fix();
                        iter = this.intervals.iterator();
                        low = -1L;
                        interval = null;
                        continue;
                    }
                    throw new IllegalArgumentException("constructing invalid interval  while trying to invert \n" + this.toString() + " \n with size " + maxSize + " low:" + low + " interval.low:" + interval.getLow());
                }
                ret.add(Range.createRange(low + 1L, interval.getLow() - 1L));
            }
            low = interval.getHigh();
        }
        assert (interval != null) : "Null interval in getFreeBlocks";
        if (interval.getHigh() < maxSize - 1L) {
            ret.add(Range.createRange(interval.getHigh() + 1L, maxSize - 1L));
        }
        return ret;
    }

    public Iterator<Range> getNeededIntervals(long maxSize) {
        return this.invert(maxSize).getAllIntervals();
    }

    public IntervalSet clone() {
        IntervalSet ret = new IntervalSet();
        for (Range interval : this) {
            ret.intervals.add(interval);
        }
        return ret;
    }

    private void addImpl(Range i) {
        int point = Collections.binarySearch(this.intervals, i, IntervalComparator.INSTANCE);
        if (point >= 0) {
            throw new IllegalStateException("interval (" + i + ") already in list: " + this.intervals);
        }
        point = -(point + 1);
        this.intervals.add(point, i);
    }

    private void removeImpl(Range i) {
        int point = Collections.binarySearch(this.intervals, i, IntervalComparator.INSTANCE);
        if (point < 0) {
            throw new IllegalStateException("interval (" + i + ") doesn't exist in list: " + this.intervals);
        }
        this.intervals.remove(point);
    }

    public String toString() {
        return this.intervals.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IntervalSet) {
            IntervalSet s = (IntervalSet)o;
            if (this.intervals.size() == s.intervals.size()) {
                for (int i = 0; i < this.intervals.size(); ++i) {
                    if (this.intervals.get(i).equals(s.intervals.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public ByteIntervals toBytes() {
        int longRanges = 0;
        for (Range current : this.intervals) {
            longRanges += current.isLong() ? 1 : 0;
        }
        byte[] ret = new byte[(this.intervals.size() - longRanges) * 8];
        byte[] ret2 = new byte[longRanges * 10];
        int pos = 0;
        int pos2 = 0;
        for (Range current : this.intervals) {
            if (current.isLong()) {
                current.toBytes(ret2, pos2);
                pos2 += 10;
                continue;
            }
            current.toBytes(ret, pos);
            pos += 8;
        }
        return new ByteIntervals(ret, ret2);
    }

    public static IntervalSet parseBytes(byte[] ranges, byte[] ranges5) throws IOException {
        int i;
        if (ranges.length % 8 != 0 || ranges5.length % 10 != 0) {
            throw new IOException();
        }
        IntervalSet ret = new IntervalSet();
        for (i = 0; i < ranges.length / 8; ++i) {
            int low = (int)ByteUtils.uint2long(ByteUtils.beb2int(ranges, i * 8));
            int high = (int)ByteUtils.uint2long(ByteUtils.beb2int(ranges, i * 8 + 4));
            if (high < low || low < 0) {
                throw new IOException();
            }
            ret.add(Range.createRange(low, high));
        }
        for (i = 0; i < ranges5.length / 10; ++i) {
            long low = ByteUtils.beb2long(ranges5, i * 10, 5);
            long high = ByteUtils.beb2long(ranges5, i * 10 + 5, 5);
            if (high < low || low < 0L) {
                throw new IOException();
            }
            ret.add(Range.createRange(low, high));
        }
        return ret;
    }

    private void fix() {
        String preIntervals = this.intervals.toString();
        ArrayList<Range> oldIntervals = new ArrayList<Range>(this.intervals);
        this.intervals.clear();
        Iterator i = oldIntervals.iterator();
        while (i.hasNext()) {
            this.add((Range)i.next());
        }
        String postIntervals = this.intervals.toString();
        ErrorService.error(new IllegalStateException("IntervalSet invariants broken.\nPre  Fixing: " + preIntervals + "\n" + "Post Fixing: " + postIntervals));
    }

    public static class ByteIntervals {
        public final byte[] ints;
        public final byte[] longs;

        private ByteIntervals(byte[] ranges, byte[] ranges5) {
            this.ints = ranges;
            this.longs = ranges5;
        }

        public int length() {
            return this.ints.length + this.longs.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntervalComparator
    implements Comparator<Range> {
        private static final IntervalComparator INSTANCE = new IntervalComparator();

        private IntervalComparator() {
        }

        @Override
        public int compare(Range ia, Range ib) {
            if (ia.getLow() > ib.getLow()) {
                return 1;
            }
            if (ia.getLow() < ib.getLow()) {
                return -1;
            }
            return 0;
        }
    }
}

