/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPartitioner<E> {
    private final List<E> list;
    private final int numPartitions;

    public ListPartitioner(List<E> list, int numPartitions) {
        assert (numPartitions > 0);
        this.list = list;
        this.numPartitions = numPartitions;
    }

    public List<E> getPartition(int index) {
        if (index >= this.numPartitions) {
            throw new NoSuchElementException();
        }
        if (this.numPartitions == 1) {
            return this.list;
        }
        if (this.list.isEmpty()) {
            return Collections.emptyList();
        }
        int partitionSize = this.list.size() / this.numActivePartitions();
        if (partitionSize * index >= this.list.size()) {
            return Collections.emptyList();
        }
        int end = partitionSize * (index + 1);
        if (this.list.size() - end <= partitionSize && index == this.numPartitions - 1) {
            end = this.list.size();
        }
        return this.list.subList(partitionSize * index, end);
    }

    public List<E> getLastPartition() {
        return this.getPartition(this.numActivePartitions() - 1);
    }

    private int numActivePartitions() {
        return Math.min(this.list.size(), this.numPartitions);
    }

    public List<E> getFirstPartition() {
        return this.getPartition(0);
    }
}

