/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import org.limewire.collection.Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericBuffer<T extends Number>
extends Buffer<T> {
    public NumericBuffer(int size) {
        super(size);
    }

    public NumericBuffer(Buffer<? extends T> other) {
        super(other);
    }

    @Override
    protected T[] createArray(int size) {
        return new Number[size + 1];
    }

    public Number average() {
        if (this.isEmpty()) {
            return 0;
        }
        Number sum = this.sum();
        if (sum instanceof Double) {
            return this.sum().doubleValue() / (double)this.size();
        }
        return this.sum().longValue() / (long)this.size();
    }

    public Number sum() {
        if (this.isEmpty()) {
            return new Integer(0);
        }
        Number n = (Number)this.first();
        if (n instanceof Float || n instanceof Double) {
            return this.doubleSum();
        }
        return this.longSum();
    }

    private double doubleSum() {
        double ret = 0.0;
        for (Number n : (Number[])this.buf) {
            if (n == null) continue;
            ret += n.doubleValue();
        }
        return ret;
    }

    private long longSum() {
        long ret = 0L;
        for (Number n : (Number[])this.buf) {
            if (n == null) continue;
            ret += n.longValue();
        }
        return ret;
    }
}

