/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import org.limewire.collection.BitField;
import org.limewire.collection.BooleanFunction;

public class OrView
extends BooleanFunction {
    public OrView(BitField first, BitField ... more) {
        super(first, more);
    }

    public boolean get(int i) {
        for (BitField bf : this.fields) {
            if (!bf.get(i)) continue;
            return true;
        }
        return false;
    }

    public int nextClearBit(int startIndex) {
        int currentIndex = startIndex;
        while (currentIndex < this.maxSize()) {
            boolean allSame = true;
            int largest = -1;
            int current = -1;
            for (int i = 0; i < this.fields.length; ++i) {
                current = this.fields[i].nextClearBit(currentIndex);
                if (current == -1) {
                    return -1;
                }
                if (i == 0) {
                    largest = current;
                    continue;
                }
                if (current == largest) continue;
                allSame = false;
                largest = Math.max(largest, current);
            }
            if (allSame) {
                return largest;
            }
            currentIndex = largest;
        }
        return -1;
    }

    public int nextSetBit(int startIndex) {
        long smallest = Long.MAX_VALUE;
        for (int i = 0; i < this.fields.length; ++i) {
            int current = this.fields[i].nextSetBit(startIndex);
            if (current == -1) continue;
            smallest = Math.min((long)current, smallest);
        }
        return smallest == Long.MAX_VALUE ? -1 : (int)smallest;
    }
}

