/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.RoundRobinQueue;
import org.limewire.concurrent.ExecutorsHelper;

public class RRProcessingQueue {
    private static final Log LOG = LogFactory.getLog(RRProcessingQueue.class);
    private final ThreadFactory FACTORY;
    private Thread _runner = null;
    private final Map<Object, NamedQueue> queues = new HashMap<Object, NamedQueue>();
    private final RoundRobinQueue<NamedQueue> lists = new RoundRobinQueue();
    private int size;

    public RRProcessingQueue(String name) {
        this.FACTORY = ExecutorsHelper.daemonThreadFactory(name);
    }

    public synchronized void execute(Runnable runner, Object queueId) {
        NamedQueue queue = this.queues.get(queueId);
        if (queue == null) {
            queue = new NamedQueue(new LinkedList<Runnable>(), queueId);
            this.queues.put(queueId, queue);
            this.lists.enqueue(queue);
        }
        queue.list.add(runner);
        ++this.size;
        this.notifyAndStart();
    }

    protected synchronized void notifyAndStart() {
        this.notify();
        if (this._runner == null) {
            this.startRunner();
        }
    }

    private synchronized void startRunner() {
        this._runner = this.FACTORY.newThread(new Processor());
        this._runner.setDaemon(true);
        this._runner.start();
    }

    protected synchronized boolean moreTasks() {
        return this.size > 0;
    }

    protected synchronized Runnable next() {
        Runnable ret = null;
        while (this.lists.size() > 0) {
            NamedQueue next = this.lists.next();
            ret = next.next();
            if (ret == null || next.list.isEmpty()) {
                this.lists.removeAllOccurences(next);
                this.queues.remove(next.name);
            }
            if (ret == null) continue;
            --this.size;
            return ret;
        }
        return null;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized void clear() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("removing all " + this.size + " jobs from " + this.queues.size() + " queues");
        }
        this.queues.clear();
        this.lists.clear();
        this.size = 0;
    }

    public synchronized void clear(Object name) {
        NamedQueue toRemove = this.queues.remove(name);
        if (toRemove == null) {
            return;
        }
        this.lists.removeAllOccurences(toRemove);
        if (LOG.isDebugEnabled()) {
            LOG.debug("removing " + toRemove.list.size() + " jobs out of " + this.size);
        }
        this.size -= toRemove.list.size();
    }

    private class Processor
    implements Runnable {
        private Processor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Runnable next;
                    if ((next = RRProcessingQueue.this.next()) != null) {
                        next.run();
                    }
                    RRProcessingQueue rRProcessingQueue = RRProcessingQueue.this;
                    synchronized (rRProcessingQueue) {
                        if (RRProcessingQueue.this.moreTasks()) {
                            continue;
                        }
                        try {
                            RRProcessingQueue.this.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!RRProcessingQueue.this.moreTasks()) return;
                    }
                }
            }
            finally {
                RRProcessingQueue rRProcessingQueue = RRProcessingQueue.this;
                synchronized (rRProcessingQueue) {
                    if (RRProcessingQueue.this.moreTasks()) {
                        RRProcessingQueue.this.startRunner();
                    } else {
                        RRProcessingQueue.this._runner = null;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NamedQueue {
        final List<Runnable> list;
        final Object name;

        NamedQueue(List<Runnable> list, Object name) {
            this.list = list;
            this.name = name;
        }

        Runnable next() {
            return this.list.isEmpty() ? null : this.list.remove(0);
        }
    }
}

