/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Collection;
import java.util.Iterator;
import org.limewire.collection.FixedSizeArrayHashSet;
import org.limewire.collection.RandomSequence;
import org.limewire.collection.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomOrderHashSet<T>
extends FixedSizeArrayHashSet<T> {
    public RandomOrderHashSet(Collection<? extends T> c) {
        super(c);
    }

    public RandomOrderHashSet(int capacity, Collection<? extends T> c) {
        super(capacity, c);
    }

    public RandomOrderHashSet(int maxSize, int initialCapacity, float loadFactor) {
        super(maxSize, initialCapacity, loadFactor);
    }

    public RandomOrderHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public Iterator<T> iterator() {
        return new RandomIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RandomIterator
    extends UnmodifiableIterator<T> {
        private final Iterator<Integer> sequence;

        private RandomIterator() {
            this.sequence = new RandomSequence(RandomOrderHashSet.this.size()).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.sequence.hasNext();
        }

        @Override
        public T next() {
            return RandomOrderHashSet.this.get(this.sequence.next());
        }
    }
}

