/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.io.Serializable;
import org.limewire.collection.Interval;
import org.limewire.collection.LongInterval;

public abstract class Range
implements Serializable {
    private static final long serialVersionUID = -2562093104400487223L;
    public static final long MAX_VALUE = 0xFFFFFFFFFFL;

    public final boolean isSubrange(Range other) {
        return this.getLow() >= other.getLow() && this.getHigh() <= other.getHigh();
    }

    public abstract byte[] toBytes();

    public abstract void toBytes(byte[] var1, int var2);

    public abstract long getLow();

    public abstract long getHigh();

    public static Range createRange(long start, long end) {
        if (start <= Integer.MAX_VALUE && end <= Integer.MAX_VALUE) {
            return new Interval(start, end);
        }
        return new LongInterval(start, end);
    }

    public static Range createRange(long singleton) {
        return Range.createRange(singleton, singleton);
    }

    public String toString() {
        if (this.getLow() == this.getHigh()) {
            return String.valueOf(this.getLow());
        }
        return String.valueOf(this.getLow()) + "-" + String.valueOf(this.getHigh());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        return this.getLow() == other.getLow() && this.getHigh() == other.getHigh();
    }

    public int hashCode() {
        return (int)(this.getLow() * this.getHigh() % Integer.MAX_VALUE);
    }

    public abstract boolean isLong();
}

