/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.limewire.collection.TreeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedList<E>
extends TreeList<E> {
    private final Comparator<? super E> comparator;

    public SortedList() {
        this.comparator = new DefaultComparator<E>();
    }

    public SortedList(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    public SortedList(Collection<? extends E> c) {
        this(c, new DefaultComparator());
    }

    public SortedList(Collection<? extends E> c, Comparator<? super E> comparator) {
        super(c);
        this.comparator = comparator;
    }

    @Override
    public boolean add(E e) {
        this.add(this.getIndex(e), e);
        return true;
    }

    private int getIndex(E e) {
        int point = Collections.binarySearch(this, e, this.comparator);
        if (point < 0) {
            point = -(point + 1);
        }
        return point;
    }

    public E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    public E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(this.size() - 1);
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultComparator<E>
    implements Comparator<E> {
        private DefaultComparator() {
        }

        @Override
        public int compare(E a, E b) {
            Comparable ac = (Comparable)a;
            return ac.compareTo(b);
        }
    }
}

