/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.limewire.collection.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseIntSet
extends AbstractSet<Integer> {
    private int[] list = new int[0];
    private int size;
    private int modCount;

    public SparseIntSet() {
        this(8);
    }

    public SparseIntSet(int initialCapacity) {
        this.ensureCapacity(initialCapacity);
    }

    public SparseIntSet(Collection<? extends Integer> c) {
        this.addAll(c);
    }

    public void compact() {
        int oldCapacity = this.list.length;
        if (this.size < oldCapacity) {
            int[] copy = new int[this.size];
            System.arraycopy(this.list, 0, copy, 0, this.size);
            this.list = copy;
        }
    }

    public int getActualMemoryUsed() {
        return this.list.length * 4;
    }

    public int nextSetBit(int fromIndex) {
        int position = this.binarySearch(fromIndex);
        if (position < 0) {
            position = -(position + 1);
        }
        if (position == this.size) {
            return -1;
        }
        return this.list[position];
    }

    @Override
    public boolean add(Integer i) {
        int point = this.binarySearch(i);
        if (point >= 0) {
            return false;
        }
        point = -(point + 1);
        this.ensureCapacity(this.size + 1);
        ++this.size;
        System.arraycopy(this.list, point, this.list, point + 1, this.size - point - 1);
        this.list[point] = i;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        if (c.isEmpty()) {
            return false;
        }
        if (c instanceof SparseIntSet || c instanceof SortedSet) {
            if (this.isEmpty()) {
                this.fillFromSorted(c);
                return true;
            }
            int[] newList = new int[this.size() + c.size()];
            Iterator<Integer> us = this.iterator();
            Iterator<? extends Integer> them = c.iterator();
            int index = 0;
            boolean modified = false;
            int biggest = Integer.MIN_VALUE;
            boolean lastUs = true;
            boolean lastThem = true;
            while (us.hasNext() || them.hasNext()) {
                int a = biggest;
                int b = biggest;
                if (lastUs && us.hasNext()) {
                    a = us.next();
                }
                if (lastThem && them.hasNext()) {
                    b = them.next();
                }
                biggest = Math.max(a, b);
                if (index > 0 && newList[index - 1] == Math.min(a, b)) continue;
                if (a < b) {
                    newList[index] = a;
                    lastUs = true;
                    lastThem = false;
                } else if (a > b) {
                    modified = true;
                    newList[index] = b;
                    lastUs = false;
                    lastThem = true;
                } else {
                    newList[index] = a;
                    lastUs = true;
                    lastThem = true;
                }
                ++index;
            }
            if (newList[index - 1] != biggest) {
                newList[index++] = biggest;
            }
            this.list = newList;
            this.size = index;
            this.compact();
            return modified;
        }
        this.ensureCapacity(this.size() + c.size());
        boolean ret = super.addAll(c);
        this.compact();
        return ret;
    }

    private void fillFromSorted(Collection<? extends Integer> c) {
        this.list = new int[c.size()];
        Iterator<? extends Integer> i$ = c.iterator();
        while (i$.hasNext()) {
            int i = i$.next();
            this.list[++this.size - 1] = i;
        }
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.list.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            int[] copy = new int[newCapacity];
            System.arraycopy(this.list, 0, copy, 0, this.size);
            this.list = copy;
        }
    }

    private int binarySearch(int key) {
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int midVal = this.list[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Integer)) {
            return false;
        }
        int i = (Integer)o;
        int point = this.binarySearch(i);
        if (point < 0) {
            return false;
        }
        int numMoved = this.size - point - 1;
        if (numMoved > 0) {
            System.arraycopy(this.list, point + 1, this.list, point, numMoved);
        }
        --this.size;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Integer)) {
            return false;
        }
        int i = (Integer)o;
        int point = this.binarySearch(i);
        return point >= 0;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new ArrayIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean retainAll(Collection<?> o) {
        SparseIntSet toRemove = new SparseIntSet();
        for (int contained : this) {
            if (o.contains(contained)) continue;
            toRemove.add(contained);
        }
        return this.removeAll(toRemove);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayIterator
    extends UnmodifiableIterator<Integer> {
        private int index;
        private final int mod;

        private ArrayIterator() {
            this.mod = SparseIntSet.this.modCount;
        }

        private void checkModification() {
            if (SparseIntSet.this.modCount != this.mod) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < SparseIntSet.this.size;
        }

        @Override
        public Integer next() {
            this.checkModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return SparseIntSet.this.list[this.index++];
        }
    }
}

