/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.limewire.collection.EmptyIterator;
import org.limewire.collection.Function;
import org.limewire.collection.TrieEdge;
import org.limewire.collection.TrieNode;
import org.limewire.collection.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTrie<V> {
    private TrieNode<V> root;
    private boolean ignoreCase;

    public StringTrie(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.clear();
    }

    public void clear() {
        this.root = new TrieNode();
    }

    public String canonicalCase(String s) {
        if (!this.ignoreCase) {
            return s;
        }
        return s.toUpperCase(Locale.US).toLowerCase(Locale.US);
    }

    private final int match(String a, int startOffset, int stopOffset, String b) {
        int i = startOffset;
        for (int j = 0; j < b.length(); ++j) {
            if (i >= stopOffset) {
                return j;
            }
            if (a.charAt(i) != b.charAt(j)) {
                return j;
            }
            ++i;
        }
        return -1;
    }

    public V add(String key, V value) {
        String label;
        key = this.canonicalCase(key);
        TrieNode<V> node = this.root;
        for (int i = 0; i < key.length(); i += label.length()) {
            TrieEdge<V> edge = node.get(key.charAt(i));
            if (edge == null) {
                TrieNode<V> newNode = new TrieNode<V>(value);
                node.put(key.substring(i), newNode);
                return null;
            }
            label = edge.getLabel();
            int j = this.match(key, i, key.length(), label);
            assert (j != 0) : "Label didn't start with prefix[0].";
            if (j >= 0) {
                TrieNode<V> child = edge.getChild();
                TrieNode<V> intermediate = new TrieNode<V>();
                String a = label.substring(0, j);
                String b = label.substring(j);
                String c = key.substring(i + j);
                if (c.length() > 0) {
                    TrieNode<V> newNode = new TrieNode<V>(value);
                    node.remove(label.charAt(0));
                    node.put(a, intermediate);
                    intermediate.put(b, child);
                    intermediate.put(c, newNode);
                } else {
                    node.remove(label.charAt(0));
                    node.put(a, intermediate);
                    intermediate.put(b, child);
                    intermediate.setValue(value);
                }
                return null;
            }
            assert (j == -1) : "Bad return value from match: " + i;
            node = edge.getChild();
        }
        V ret = node.getValue();
        node.setValue(value);
        return ret;
    }

    private TrieNode<V> fetch(String prefix) {
        String label;
        TrieNode<V> node = this.root;
        for (int i = 0; i < prefix.length(); i += label.length()) {
            TrieEdge<V> edge = node.get(prefix.charAt(i));
            if (edge == null) {
                return null;
            }
            label = edge.getLabel();
            int j = this.match(prefix, i, prefix.length(), label);
            assert (j != 0) : "Label didn't start with prefix[0].";
            if (j != -1) {
                return null;
            }
            node = edge.getChild();
        }
        return node;
    }

    public V get(String key) {
        TrieNode<V> node = this.fetch(key = this.canonicalCase(key));
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    public boolean remove(String key) {
        TrieNode<V> node = this.fetch(key = this.canonicalCase(key));
        if (node == null) {
            return false;
        }
        boolean ret = node.getValue() != null;
        node.setValue(null);
        return ret;
    }

    public Iterator<V> getPrefixedBy(String prefix) {
        prefix = this.canonicalCase(prefix);
        return this.getPrefixedBy(prefix, 0, prefix.length());
    }

    public Iterator<V> getPrefixedBy(String prefix, int startOffset, int stopOffset) {
        String label;
        TrieNode<V> node = this.root;
        for (int i = startOffset; i < stopOffset; i += label.length()) {
            TrieEdge<V> edge = node.get(prefix.charAt(i));
            if (edge == null) {
                return EmptyIterator.emptyIterator();
            }
            node = edge.getChild();
            label = edge.getLabel();
            int j = this.match(prefix, i, stopOffset, label);
            assert (j != 0) : "Label didn't start with prefix[0].";
            if (i + j == stopOffset) break;
            if (j >= 0) {
                node = null;
                break;
            }
            assert (j == -1) : "Bad return value from match: " + i;
        }
        if (node == null) {
            return EmptyIterator.emptyIterator();
        }
        return new ValueIterator(node);
    }

    public Iterator<V> getIterator() {
        return new ValueIterator(this.root);
    }

    public int size() {
        int ret = 0;
        Iterator<V> iter = this.getIterator();
        while (iter.hasNext()) {
            ++ret;
        }
        return ret;
    }

    public void trim(Function<V, ? extends V> valueCompactor) throws IllegalArgumentException, ClassCastException {
        if (valueCompactor != null) {
            NodeIterator iter = new NodeIterator(this.root, true);
            while (iter.hasNext()) {
                TrieNode node = (TrieNode)iter.next();
                node.trim();
                Object value = node.getValue();
                if (value == null) continue;
                node.setValue(valueCompactor.apply(value));
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<root>");
        this.toStringHelper(this.root, buf, 1);
        return buf.toString();
    }

    private void toStringHelper(TrieNode start, StringBuilder buf, int indent) {
        if (start.getValue() != null) {
            buf.append(" -> ");
            buf.append(start.getValue().toString());
        }
        buf.append("\n");
        Iterator<String> iter = start.labelsForward();
        while (iter.hasNext()) {
            for (int i = 0; i < indent; ++i) {
                buf.append(" ");
            }
            String label = iter.next();
            buf.append(label);
            TrieNode child = start.get(label.charAt(0)).getChild();
            this.toStringHelper(child, buf, indent + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NodeIterator
    extends UnmodifiableIterator<TrieNode<V>> {
        private ArrayList<Iterator<TrieNode<V>>> stack = new ArrayList();
        private TrieNode<V> nextNode;
        private boolean withNulls;

        public NodeIterator(TrieNode<V> start, boolean withNulls) {
            this.withNulls = withNulls;
            if (withNulls || start.getValue() != null) {
                this.nextNode = start;
            } else {
                this.nextNode = null;
                this.advance(start);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty() || this.nextNode != null;
        }

        @Override
        public TrieNode<V> next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            TrieNode node = this.nextNode;
            this.nextNode = null;
            this.advance(node);
            return node;
        }

        private void advance(TrieNode<V> node) {
            Iterator children = node.childrenForward();
            while (true) {
                if (children.hasNext()) {
                    node = children.next();
                    if (children.hasNext()) {
                        this.stack.add(children);
                    }
                    if (this.withNulls || node.getValue() == null) {
                        children = node.childrenForward();
                        continue;
                    }
                    this.nextNode = node;
                    return;
                }
                int size = this.stack.size();
                if (size == 0) {
                    return;
                }
                children = this.stack.remove(size - 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends UnmodifiableIterator<V> {
        private NodeIterator delegate;

        ValueIterator(TrieNode<V> start) {
            this.delegate = new NodeIterator(start, false);
        }

        @Override
        public V next() {
            return ((TrieNode)this.delegate.next()).getValue();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }
    }
}

