/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.limewire.collection.NodeGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeStorage {
    private static final TreeNode PADDING = new TreeNode();
    private final TreeNodeMap map = new TreeNodeMap(false);
    private final NodeGenerator generator;
    private final int maxId;
    private boolean allowUnverifiedUse;

    TreeStorage(byte[] rootHash, NodeGenerator generator, int numLeafs) {
        this.generator = generator;
        this.maxId = (1 << TreeStorage.log2Ceil(numLeafs)) + numLeafs - 1;
        assert (this.maxId == this.fileToNodeId(numLeafs - 1)) : "max Id: " + this.maxId + " vs " + this.fileToNodeId(numLeafs - 1);
        TreeNode root = new TreeNode(1, rootHash);
        root.verified = true;
        this.map.put(1, root);
    }

    public void setAllowUnverifiedUse(boolean allow) {
        this.allowUnverifiedUse = allow;
    }

    public boolean add(int id, byte[] data) {
        assert (id > 0 && id <= this.maxId) : "bad id " + id;
        TreeNode tn = this.map.get(id);
        if (tn != null && tn.verified) {
            return false;
        }
        TreeNode newNode = new TreeNode(id, data);
        this.verify(newNode);
        this.map.put(id, newNode);
        return newNode.verified;
    }

    public byte[] get(int id) {
        TreeNode tn = this.map.get(id);
        if (tn != null && tn.verified) {
            return tn.data;
        }
        return null;
    }

    public void used(int id) {
        TreeNode tn = this.map.get(id);
        assert (tn != null);
        assert (this.allowUnverifiedUse || tn.verified);
        tn.used = true;
        this.consolidate(tn);
    }

    public Collection<Integer> getUsedNodes() {
        ArrayList<Integer> l = new ArrayList<Integer>(this.map.size());
        for (int i : this.map) {
            if (!this.map.get(i).used) continue;
            l.add(i);
        }
        return l;
    }

    public Collection<Integer> getVerifiedNodes() {
        ArrayList<Integer> l = new ArrayList<Integer>(this.map.size());
        for (int i : this.map) {
            if (!this.map.get(i).verified) continue;
            l.add(i);
        }
        return l;
    }

    private void consolidate(TreeNode node) {
        TreeNode parent;
        TreeNode[] siblings = this.getSiblings(node);
        if (siblings[0] == null || siblings[1] == null) {
            return;
        }
        if (!siblings[0].used || !siblings[1].used) {
            return;
        }
        TreeNode existingParent = this.map.get(node.id / 2);
        if (existingParent != null) {
            assert (this.allowUnverifiedUse || existingParent.verified);
            assert (!existingParent.used);
            parent = existingParent;
        } else {
            parent = this.generateParent(siblings);
        }
        parent.verified = true;
        parent.used = true;
        this.map.remove(siblings[0].id);
        this.map.remove(siblings[1].id);
        this.map.put(parent.id, parent);
        this.consolidate(parent);
    }

    private TreeNode[] getSiblings(TreeNode oneOfThem) {
        TreeNode[] ret = new TreeNode[2];
        if (oneOfThem.id % 2 == 0) {
            ret[0] = oneOfThem;
            ret[1] = oneOfThem.id == this.maxId ? PADDING : this.map.get(oneOfThem.id + 1);
        } else {
            ret[0] = this.map.get(oneOfThem.id - 1);
            ret[1] = oneOfThem;
        }
        return ret;
    }

    private void verify(TreeNode node) {
        boolean same;
        TreeNode[] siblings = this.getSiblings(node);
        if (siblings[0] == null || siblings[1] == null) {
            return;
        }
        assert (!(!this.allowUnverifiedUse && siblings[0].verified || siblings[1].verified && siblings[1] != PADDING));
        TreeNode parent = this.generateParent(siblings);
        TreeNode existingParent = this.map.get(parent.id);
        boolean bl = same = existingParent != null && Arrays.equals(existingParent.data, parent.data);
        if (same) {
            parent = existingParent;
        }
        if (!parent.verified) {
            this.verify(parent);
        }
        if (parent.verified) {
            this.markVerified(siblings[0]);
            this.markVerified(siblings[1]);
            if (parent.id != 1) {
                this.map.remove(parent.id);
            }
        } else if (parent.id != 1) {
            this.map.put(parent.id, parent);
        }
    }

    private void markVerified(TreeNode node) {
        if (node == null || node == PADDING || node.id == 1) {
            return;
        }
        this.map.remove(node.id);
        node.verified = true;
        this.map.put(node.id, node);
        TreeNode left = this.map.get(node.id * 2);
        TreeNode right = this.map.get(node.id * 2 + 1);
        if (left != null && right != null) {
            this.map.remove(node.id);
        }
        this.markVerified(left);
        this.markVerified(right);
    }

    private TreeNode generateParent(TreeNode[] children) {
        byte[] data = children[1] == PADDING ? children[0].data : this.generator.generate(children[0].data, children[1].data);
        return new TreeNode(children[0].id / 2, data);
    }

    public static int log2Ceil(long number) {
        int n = 0;
        while (number > 1L) {
            ++number;
            number >>>= 1;
            ++n;
        }
        return n;
    }

    public int fileToNodeId(int fileId) {
        int power = TreeStorage.log2Ceil(this.maxId);
        int ret = (1 << Math.max(0, power - 1)) + fileId;
        if (ret > this.maxId) {
            throw new IllegalArgumentException("fileId " + fileId + " maxId " + this.maxId + " ret " + ret);
        }
        return ret;
    }

    public int[] nodeToFileId(int nodeId) {
        if (nodeId < 1 || nodeId > this.maxId) {
            return null;
        }
        int power = Math.max(1, 1 << TreeStorage.log2Ceil(this.maxId) - 1);
        if (nodeId == 1) {
            return new int[]{0, this.maxId - power};
        }
        int[] ret = new int[2];
        int times = 0;
        while (nodeId < power) {
            ++times;
            nodeId <<= 1;
        }
        if (nodeId > this.maxId) {
            return null;
        }
        ret[0] = nodeId - power;
        ret[1] = Math.min(this.maxId - power, ret[0] + (1 << times) - 1);
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeNodeMap
    implements Iterable<Integer> {
        private final Map<Integer, TreeNode> hardMap = new TreeMap<Integer, TreeNode>();
        private final Map<Integer, SoftReference<TreeNode>> softMap = new TreeMap<Integer, SoftReference<TreeNode>>();
        private final boolean soft;

        TreeNodeMap(boolean soft) {
            this.soft = soft;
        }

        public TreeNode get(int id) {
            TreeNode ret = this.hardMap.get(id);
            if (ret != null || !this.soft) {
                return ret;
            }
            SoftReference<TreeNode> sr = this.softMap.get(id);
            if (sr == null) {
                return null;
            }
            return sr.get();
        }

        public TreeNode put(int id, TreeNode node) {
            if (this.soft) {
                this.softMap.remove(id);
            }
            return this.hardMap.put(id, node);
        }

        public TreeNode remove(int id) {
            TreeNode n = this.hardMap.remove(id);
            if (n != null && this.soft) {
                this.softMap.put(id, new SoftReference<TreeNode>(n));
            }
            return n;
        }

        public int size() {
            return this.hardMap.size();
        }

        @Override
        public Iterator<Integer> iterator() {
            if (this.soft) {
                return new CachingIterator();
            }
            return this.hardMap.keySet().iterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CachingIterator
        implements Iterator<Integer> {
            private final Iterator<Integer> hardIterator;
            private int currentId;
            private TreeNode currentNode;

            private CachingIterator() {
                this.hardIterator = TreeNodeMap.this.hardMap.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.hardIterator.hasNext();
            }

            @Override
            public Integer next() {
                this.currentId = this.hardIterator.next();
                this.currentNode = (TreeNode)TreeNodeMap.this.hardMap.get(this.currentId);
                return this.currentId;
            }

            @Override
            public void remove() {
                if (this.currentId <= 0) {
                    throw new IllegalStateException();
                }
                this.hardIterator.remove();
                TreeNodeMap.this.softMap.put(this.currentId, new SoftReference<TreeNode>(this.currentNode));
                this.currentId = 0;
                this.currentNode = null;
            }
        }
    }

    private static class TreeNode {
        private final int id;
        private final byte[] data;
        private boolean used;
        private boolean verified;

        TreeNode() {
            this.id = Integer.MAX_VALUE;
            this.data = null;
            this.used = true;
            this.verified = true;
        }

        TreeNode(int id, byte[] data) {
            this.id = id;
            this.data = data;
        }

        public String toString() {
            return "id " + this.id + " verified " + this.verified + " used " + this.used;
        }
    }
}

