/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.limewire.concurrent.ManagedThread;
import org.limewire.concurrent.ThreadPoolExecutor;

public class ExecutorsHelper {
    public static ExecutorService newProcessingQueue(String name) {
        return ExecutorsHelper.newProcessingQueue(ExecutorsHelper.daemonThreadFactory(name));
    }

    public static ExecutorService newProcessingQueue(ThreadFactory factory) {
        return Executors.unconfigurableExecutorService(ExecutorsHelper.newSingleThreadExecutor(factory));
    }

    public static java.util.concurrent.ThreadPoolExecutor newSingleThreadExecutor(ThreadFactory factory) {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory);
        tpe.allowCoreThreadTimeOut(true);
        return tpe;
    }

    public static ExecutorService newThreadPool(String name) {
        return Executors.unconfigurableExecutorService(new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ExecutorsHelper.daemonThreadFactory(name)));
    }

    public static ExecutorService newThreadPool(ThreadFactory factory) {
        return Executors.unconfigurableExecutorService(new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), factory));
    }

    public static ExecutorService newFixedSizeThreadPool(int size, String name) {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(size, size, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ExecutorsHelper.daemonThreadFactory(name));
        tpe.allowCoreThreadTimeOut(true);
        return Executors.unconfigurableExecutorService(tpe);
    }

    public static ThreadFactory defaultThreadFactory(String name) {
        return new DefaultThreadFactory(name, false);
    }

    public static ThreadFactory daemonThreadFactory(String name) {
        return new DefaultThreadFactory(name, true);
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private final String name;
        private final boolean daemon;

        public DefaultThreadFactory(String name, boolean daemon) {
            this.name = name;
            this.daemon = daemon;
        }

        public Thread newThread(Runnable r) {
            ManagedThread t = new ManagedThread(r, this.name);
            if (this.daemon) {
                t.setDaemon(true);
            }
            return t;
        }
    }
}

