/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnewayExchanger<V, E extends Throwable> {
    private boolean done = false;
    private boolean cancelled = false;
    private final boolean oneShot;
    private V value;
    private E exception;

    public OnewayExchanger() {
        this(false);
    }

    public OnewayExchanger(boolean oneShot) {
        this.oneShot = oneShot;
    }

    public synchronized V get() throws InterruptedException, E {
        try {
            return this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException cannotHappen) {
            throw new Error(cannotHappen);
        }
    }

    public synchronized V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, E {
        if (!this.done) {
            if (timeout == 0L) {
                this.wait();
            } else {
                unit.timedWait(this, timeout);
            }
            if (!this.done) {
                throw new TimeoutException();
            }
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    public synchronized V tryGet() throws InterruptedException, E {
        if (this.done) {
            return this.get();
        }
        return null;
    }

    public synchronized boolean cancel() {
        if (this.done) {
            return this.cancelled;
        }
        this.done = true;
        this.cancelled = true;
        this.notifyAll();
        return true;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized boolean throwsException() {
        return this.cancelled || this.exception != null;
    }

    public boolean isOneShot() {
        return this.oneShot;
    }

    public synchronized void setValue(V value) {
        if (this.cancelled) {
            return;
        }
        if (this.done && this.oneShot) {
            throw new IllegalStateException("The OnewayExchanger is configured for a single shot");
        }
        this.done = true;
        this.value = value;
        this.notifyAll();
    }

    public synchronized void setException(E exception) {
        if (exception == null) {
            throw new NullPointerException();
        }
        if (this.cancelled) {
            return;
        }
        if (this.done && this.oneShot) {
            throw new IllegalStateException("The OnewayExchanger is configured for a single shot");
        }
        this.done = true;
        this.exception = exception;
        this.notifyAll();
    }

    public synchronized void reset() {
        if (this.oneShot) {
            throw new IllegalStateException("The OnewayExchanger is configured for a single shot");
        }
        this.done = false;
        this.cancelled = false;
        this.value = null;
        this.exception = null;
    }
}

