/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTimer
extends AbstractExecutorService
implements ScheduledExecutorService {
    private final Timer TIMER;
    private volatile boolean cancelled = false;

    public SimpleTimer(boolean isDaemon) {
        this.TIMER = new Timer(isDaemon);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        ScheduledTimerTask future = new ScheduledTimerTask(command);
        this.scheduleInternal(future, unit.toMillis(delay), 0L, false);
        return future;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        ScheduledTimerTask<V> future = new ScheduledTimerTask<V>(callable);
        this.scheduleInternal(future, unit.toMillis(delay), 0L, false);
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        ScheduledTimerTask future = new ScheduledTimerTask(command);
        this.scheduleInternal(future, unit.toMillis(initialDelay), unit.toMillis(period), true);
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        ScheduledTimerTask future = new ScheduledTimerTask(command);
        this.scheduleInternal(future, unit.toMillis(initialDelay), unit.toMillis(delay), false);
        return future;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        return this.cancelled;
    }

    @Override
    public boolean isTerminated() {
        return this.cancelled;
    }

    @Override
    public void shutdown() {
        this.cancelled = true;
        this.TIMER.cancel();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public void execute(final Runnable command) {
        TimerTask tt = new TimerTask(){

            public void run() {
                try {
                    command.run();
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        };
        this.scheduleInternal(tt, 0L, 0L, false);
    }

    private void scheduleInternal(TimerTask task, long delay, long period, boolean fixedRate) {
        block7: {
            try {
                if (period == 0L) {
                    if (fixedRate) {
                        throw new IllegalArgumentException("cannot support 0 period w/ fixedRate");
                    }
                    this.TIMER.schedule(task, delay);
                } else if (fixedRate) {
                    this.TIMER.scheduleAtFixedRate(task, delay, period);
                } else {
                    this.TIMER.schedule(task, delay, period);
                }
            }
            catch (IllegalStateException ise) {
                if (!this.cancelled) break block7;
                throw ise;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResetableFutureTask<V>
    extends FutureTask<V> {
        @Override
        public boolean runAndReset() {
            return super.runAndReset();
        }

        public ResetableFutureTask(Runnable runnable, V result) {
            super(runnable, result);
        }

        public ResetableFutureTask(Callable<V> callable) {
            super(callable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScheduledTimerTask<V>
    extends TimerTask
    implements ScheduledFuture<V> {
        private final ResetableFutureTask<V> task;

        public ScheduledTimerTask(final Runnable r) {
            this.task = new ResetableFutureTask<Object>(new Runnable(){

                public void run() {
                    try {
                        r.run();
                    }
                    catch (Throwable t) {
                        ErrorService.error(t);
                    }
                }
            }, null);
        }

        public ScheduledTimerTask(final Callable<V> c) {
            this.task = new ResetableFutureTask(new Callable<V>(){

                @Override
                public V call() {
                    try {
                        Object v = c.call();
                        return v;
                    }
                    catch (Throwable t) {
                        ErrorService.error(t);
                        return null;
                    }
                }
            });
        }

        @Override
        public void run() {
            this.task.runAndReset();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return -1L;
        }

        @Override
        public int compareTo(Delayed o) {
            return 0;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.task.cancel(true);
            return this.cancel();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.task.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.task.get(timeout, unit);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }
    }
}

