/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.geocode;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.limewire.geocode.GeocodeInformation;
import org.limewire.geocode.Geocoder;

public abstract class AbstractGeocoder
implements Geocoder {
    private GeocodeInformation info;
    private Throwable reasonForFailure;

    public GeocodeInformation getGeocodeInformation() {
        return this.info;
    }

    public boolean isReady() {
        return this.hasFailed() || this.info != null;
    }

    public boolean hasFailed() {
        return this.reasonForFailure != null;
    }

    public void clear() {
        this.info = null;
    }

    protected void setInvalid(Throwable reasonForFailure) {
        this.reasonForFailure = reasonForFailure;
    }

    Throwable getReasonForFailure() {
        return this.reasonForFailure;
    }

    protected void setGeocodeInformation(InputStream is) throws IOException {
        String line;
        GeocodeInformation res = new GeocodeInformation();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        in.readLine();
        while ((line = in.readLine()) != null) {
            String[] parts;
            if (line.equals("") || (parts = line.split("\t")).length < 2) continue;
            String name = parts[0];
            String value = parts[1];
            res.setProperty(name, value);
        }
        this.info = res;
    }
}

