/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.geocode;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeocodeInformation {
    private final Map<Property, String> names2values = new HashMap<Property, String>();
    private static final Map<String, Property> STRINGS2PROPERTIES = new HashMap<String, Property>();

    public String getProperty(Property p) {
        return this.names2values.get((Object)p);
    }

    public void setProperty(String name, String value) {
        Property prop = GeocodeInformation.getStrings2Properties().get(name);
        if (prop != null && value != null) {
            this.setProperty(prop, value);
        }
    }

    public void setProperty(Property p, String value) {
        this.names2values.put(p, value);
    }

    public String toString() {
        return String.valueOf(this.names2values);
    }

    public static Map<String, Property> getStrings2Properties() {
        return STRINGS2PROPERTIES;
    }

    public Properties toProperties() {
        Properties props = new Properties();
        for (Map.Entry<Property, String> entry : this.names2values.entrySet()) {
            props.setProperty(entry.getKey().getValue(), entry.getValue());
        }
        return props;
    }

    public static GeocodeInformation fromProperties(Properties props) {
        if (props.isEmpty()) {
            return null;
        }
        GeocodeInformation info = new GeocodeInformation();
        for (Property property : Property.values()) {
            String value = props.getProperty(property.getValue());
            if (value == null) continue;
            info.setProperty(property, value);
        }
        return info;
    }

    static {
        Property.AreaCode.getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        Ip("Ip"),
        CountryCode("CountryCode"),
        CountryCode3("CountryCode3"),
        CountryName("CountryName"),
        Region("Region"),
        Region2("Region2"),
        City("City"),
        PostalCode("PostalCode"),
        Latitude("Latitude"),
        Longitude("Longitude"),
        DmaCode("DmaCode"),
        AreaCode("AreaCode");

        private final String s;

        private Property(String s) {
            this.s = s;
            GeocodeInformation.getStrings2Properties().put(s, this);
        }

        public String getValue() {
            return this.s;
        }
    }
}

