/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.HeaderInterceptor;
import org.limewire.http.MalformedHeaderException;

public class RangeHeaderInterceptor
implements HeaderInterceptor {
    public static String RANGE_HEADER = "Range";
    private List<Range> ranges;

    public void process(Header header, HttpContext context) throws HttpException, IOException {
        if (!RANGE_HEADER.equals(header.getName())) {
            return;
        }
        String value = header.getValue().trim();
        if (!value.startsWith("bytes")) {
            throw new MalformedHeaderException("bytes not present in range header");
        }
        if (value.length() <= 6) {
            throw new MalformedHeaderException("range not present in range header");
        }
        value = value.substring(6);
        StringTokenizer t = new StringTokenizer(value, ",");
        while (t.hasMoreElements()) {
            Range range = this.parseRange(t.nextToken().trim());
            if (this.ranges == null) {
                this.ranges = new ArrayList<Range>(1);
            }
            this.ranges.add(range);
        }
    }

    private Range parseRange(String value) throws MalformedHeaderException {
        if (value.length() < 2) {
            throw new MalformedHeaderException("invalid range: " + value);
        }
        Range range = new Range();
        int i = value.indexOf("-");
        if (i == -1 || value.indexOf("-", i + 1) != -1) {
            throw new MalformedHeaderException("invalid range: " + value);
        }
        if (i == 0) {
            try {
                range.endOffset = Long.parseLong(value.substring(1).trim());
            }
            catch (NumberFormatException e) {
                throw new MalformedHeaderException();
            }
        }
        if (i == value.length() - 1) {
            try {
                range.startOffset = Long.parseLong(value.substring(0, value.length() - 1).trim());
            }
            catch (NumberFormatException e) {
                throw new MalformedHeaderException();
            }
        }
        try {
            range.startOffset = Long.parseLong(value.substring(0, i).trim());
        }
        catch (NumberFormatException e) {
            throw new MalformedHeaderException();
        }
        try {
            range.endOffset = Long.parseLong(value.substring(i + 1).trim());
        }
        catch (NumberFormatException e) {
            throw new MalformedHeaderException();
        }
        if (range.endOffset != -1L && range.startOffset > range.endOffset) {
            throw new MalformedHeaderException("start offset is greater than end offset (" + range.startOffset + ">" + range.endOffset + ")");
        }
        assert (range.startOffset >= 0L || range.endOffset >= 0L);
        return range;
    }

    public boolean hasRequestedRanges() {
        return this.ranges != null;
    }

    public Range[] getRequestedRanges() {
        return this.ranges != null ? this.ranges.toArray(new Range[0]) : null;
    }

    public static class Range {
        private long startOffset = -1L;
        private long endOffset = -1L;

        protected Range(long startOffset, long endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        private Range() {
        }

        public long getStartOffset(long totalSize) {
            if (totalSize < 0L) {
                throw new IllegalArgumentException("totalSize must be >= 0");
            }
            if (this.startOffset > totalSize - 1L) {
                return -1L;
            }
            if (this.startOffset >= 0L) {
                return this.startOffset;
            }
            if (totalSize >= this.endOffset) {
                return totalSize - this.endOffset;
            }
            return 0L;
        }

        public long getEndOffset(long totalSize) {
            if (totalSize < 0L) {
                throw new IllegalArgumentException("totalSize must be >= 0");
            }
            if (this.startOffset >= 0L) {
                if (this.endOffset >= 0L && this.endOffset < totalSize) {
                    return this.endOffset;
                }
                return totalSize - 1L;
            }
            return totalSize - 1L;
        }
    }
}

