/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.handler;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.limewire.http.handler.MimeTypeProvider;

public class BasicMimeTypeProvider
implements MimeTypeProvider {
    private final Map<String, String> mimeTypeByExtension = Collections.synchronizedMap(new HashMap());
    private final String defaultMimeType;

    public BasicMimeTypeProvider(String defaultMimeType) {
        if (defaultMimeType == null) {
            throw new IllegalArgumentException();
        }
        this.defaultMimeType = defaultMimeType;
        this.addMimeTypeByExtension("css", "text/css");
        this.addMimeTypeByExtension("gif", "image/gif");
        this.addMimeTypeByExtension("ico", "image/x-icon");
        this.addMimeTypeByExtension("jpg", "image/jpg");
        this.addMimeTypeByExtension("png", "image/png");
        this.addMimeTypeByExtension("htm", "text/html");
        this.addMimeTypeByExtension("html", "text/html");
        this.addMimeTypeByExtension("img", "image/gif");
        this.addMimeTypeByExtension("js", "application/x-javascript");
    }

    public BasicMimeTypeProvider() {
        this("application/octet-stream");
    }

    public void addMimeTypeByExtension(String extension, String mimeType) {
        this.mimeTypeByExtension.put(extension, mimeType);
    }

    public void removeMimeTypeByExtension(String extension) {
        this.mimeTypeByExtension.remove(extension);
    }

    public String getMimeType(File file) {
        String mimeType = this.mimeTypeByExtension.get(this.getExtension(file));
        return mimeType != null ? mimeType : this.defaultMimeType;
    }

    private String getExtension(File file) {
        String name = file.getName();
        int i = name.lastIndexOf(".");
        return i != -1 ? name.substring(i + 1) : name;
    }
}

