/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.httpclient;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.concurrent.AbstractLazySingletonProvider;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.http.httpclient.LimeHttpClientImpl;
import org.limewire.http.httpclient.ReapingClientConnectionManager;
import org.limewire.http.httpclient.SocketWrapperProtocolSocketFactory;
import org.limewire.http.httpclient.SocketWrappingHttpClient;
import org.limewire.net.SocketsManager;
import org.limewire.nio.NBSocket;

public class LimeWireHttpClientModule
extends AbstractModule {
    protected void configure() {
        this.bind(ReapingClientConnectionManager.class).annotatedWith(Names.named("nonBlockingConnectionManager")).toProvider(LimeClientConnectionManagerProvider.class).in(Scopes.SINGLETON);
        this.bind(ReapingClientConnectionManager.class).annotatedWith(Names.named("socketWrappingConnectionManager")).toProvider(SocketWrappingClientConnectionManagerProvider.class).in(Scopes.SINGLETON);
        this.bind(LimeHttpClient.class).toProvider(NonBlockingLimeHttpClientProvider.class);
        this.bind(SocketWrappingHttpClient.class).toProvider(SocketWrappingLimeHttpClientProvider.class);
        this.bind(SchemeRegistry.class).annotatedWith(Names.named("limeSchemeRegistry")).toProvider(LimeSchemeRegistryProvider.class);
        this.bind(SchemeRegistry.class).annotatedWith(Names.named("socketWrappingSchemeRegistry")).toProvider(SocketWrappingSchemeRegistryProvider.class);
        this.bind(SocketWrapperProtocolSocketFactory.class);
        this.bind(HttpParams.class).annotatedWith(Names.named("defaults")).toProvider(DefaultHttpParamsProvider.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class DefaultHttpParamsProvider
    implements Provider<HttpParams> {
        private static final int CONNECTION_TIMEOUT = 5000;
        private static final int TIMEOUT = 8000;
        private static final int MAXIMUM_REDIRECTS = 10;

        @Inject
        private DefaultHttpParamsProvider() {
        }

        @Override
        public HttpParams get() {
            BasicHttpParams params = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout(params, 5000);
            HttpConnectionParams.setSoTimeout(params, 8000);
            HttpClientParams.setRedirecting(params, true);
            params.setIntParameter("http.protocol.max-redirects", 10);
            return params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LimeSocketFactory
    implements SocketFactory {
        final Provider<SocketsManager> socketsManager;
        final SocketsManager.ConnectType type;

        public LimeSocketFactory(Provider<SocketsManager> socketsManager, SocketsManager.ConnectType type) {
            this.socketsManager = socketsManager;
            this.type = type;
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.socketsManager.get().create(this.type);
        }

        @Override
        public Socket connectSocket(Socket socket, String targetHost, int targetPort, InetAddress localAddress, int localPort, HttpParams httpParams) throws IOException, UnknownHostException, ConnectTimeoutException {
            if (socket == null) {
                socket = this.createSocket();
            }
            InetSocketAddress localSocketAddr = null;
            if (localAddress != null && !localAddress.isAnyLocalAddress() || localPort > 0) {
                localSocketAddr = new InetSocketAddress(localAddress, localPort);
            }
            return this.socketsManager.get().connect((NBSocket)socket, localSocketAddr, new InetSocketAddress(targetHost, targetPort), HttpConnectionParams.getConnectionTimeout(httpParams), this.type);
        }

        @Override
        public boolean isSecure(Socket socket) throws IllegalArgumentException {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class SocketWrappingClientConnectionManagerProvider
    extends AbstractClientConnectionManagerProvider {
        @Inject
        public SocketWrappingClientConnectionManagerProvider(@Named(value="socketWrappingSchemeRegistry") Provider<SchemeRegistry> registry, @Named(value="backgroundExecutor") Provider<ScheduledExecutorService> scheduler, @Named(value="defaults") Provider<HttpParams> defaultParams) {
            super(registry, scheduler, defaultParams);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class LimeClientConnectionManagerProvider
    extends AbstractClientConnectionManagerProvider {
        @Inject
        public LimeClientConnectionManagerProvider(@Named(value="limeSchemeRegistry") Provider<SchemeRegistry> registry, @Named(value="backgroundExecutor") Provider<ScheduledExecutorService> scheduler, @Named(value="defaults") Provider<HttpParams> defaultParams) {
            super(registry, scheduler, defaultParams);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractClientConnectionManagerProvider
    extends AbstractLazySingletonProvider<ReapingClientConnectionManager> {
        private final Provider<SchemeRegistry> registry;
        private final Provider<ScheduledExecutorService> scheduler;
        private final Provider<HttpParams> defaultParams;

        public AbstractClientConnectionManagerProvider(Provider<SchemeRegistry> registry, Provider<ScheduledExecutorService> scheduler, Provider<HttpParams> defaultParams) {
            this.registry = registry;
            this.scheduler = scheduler;
            this.defaultParams = defaultParams;
        }

        @Override
        public ReapingClientConnectionManager createObject() {
            return new ReapingClientConnectionManager(this.registry, this.scheduler, this.defaultParams);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class SocketWrappingSchemeRegistryProvider
    extends AbstractLazySingletonProvider<SchemeRegistry> {
        private SocketWrappingSchemeRegistryProvider() {
        }

        @Override
        protected SchemeRegistry createObject() {
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", new SocketWrapperProtocolSocketFactory(), 80));
            registry.register(new Scheme("tls", new SocketWrapperProtocolSocketFactory(), 80));
            registry.register(new Scheme("https", new SocketWrapperProtocolSocketFactory(), 80));
            return registry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class LimeSchemeRegistryProvider
    extends AbstractLazySingletonProvider<SchemeRegistry> {
        private final Provider<SocketsManager> socketsManager;

        @Inject
        public LimeSchemeRegistryProvider(Provider<SocketsManager> socketsManager) {
            this.socketsManager = socketsManager;
        }

        @Override
        protected SchemeRegistry createObject() {
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", new LimeSocketFactory(this.socketsManager, SocketsManager.ConnectType.PLAIN), 80));
            registry.register(new Scheme("tls", new LimeSocketFactory(this.socketsManager, SocketsManager.ConnectType.TLS), 80));
            registry.register(new Scheme("https", new LimeSocketFactory(this.socketsManager, SocketsManager.ConnectType.TLS), 80));
            return registry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class SocketWrappingLimeHttpClientProvider
    extends AbstractLimeHttpClientProvider {
        @Inject
        public SocketWrappingLimeHttpClientProvider(@Named(value="socketWrappingConnectionManager") ReapingClientConnectionManager manager, @Named(value="defaults") Provider<HttpParams> defaultParams) {
            super(manager, defaultParams);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class NonBlockingLimeHttpClientProvider
    extends AbstractLimeHttpClientProvider {
        @Inject
        public NonBlockingLimeHttpClientProvider(@Named(value="nonBlockingConnectionManager") ReapingClientConnectionManager manager, @Named(value="defaults") Provider<HttpParams> defaultParams) {
            super(manager, defaultParams);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractLimeHttpClientProvider
    implements Provider<SocketWrappingHttpClient> {
        private ReapingClientConnectionManager manager;
        private final Provider<HttpParams> defaultParams;

        public AbstractLimeHttpClientProvider(ReapingClientConnectionManager manager, Provider<HttpParams> defaultParams) {
            this.manager = manager;
            this.defaultParams = defaultParams;
        }

        @Override
        public SocketWrappingHttpClient get() {
            return new LimeHttpClientImpl(this.manager, this.defaultParams);
        }
    }
}

