/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.protocol;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.protocol.AsyncNHttpServiceHandler;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.limewire.http.protocol.HttpServiceEventListener;
import org.limewire.http.reactor.HttpIOSession;

public class ExtendedAsyncNHttpServiceHandler
extends AsyncNHttpServiceHandler {
    public ExtendedAsyncNHttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory responseFactory, ConnectionReuseStrategy connStrategy, ByteBufferAllocator allocator, HttpParams params) {
        super(httpProcessor, responseFactory, connStrategy, allocator, params);
    }

    public ExtendedAsyncNHttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory responseFactory, ConnectionReuseStrategy connStrategy, HttpParams params) {
        this(httpProcessor, responseFactory, connStrategy, new HeapByteBufferAllocator(), params);
    }

    public void setEventListener(HttpServiceEventListener eventListener) {
        this.eventListener = eventListener;
    }

    protected void responseComplete(HttpResponse response, HttpContext context) {
        DefaultNHttpServerConnection c;
        NHttpServerConnection conn = (NHttpServerConnection)context.getAttribute("http.connection");
        if (this.eventListener instanceof HttpServiceEventListener) {
            ((HttpServiceEventListener)this.eventListener).responseSent(conn, response);
        }
        if (conn.isOpen() && (c = (DefaultNHttpServerConnection)conn).hasBufferedInput()) {
            HttpIOSession session = (HttpIOSession)c.getContext().getAttribute("org.limewire.iosession");
            Executor executor = session.getIoExecutor();
            Runnable runner = new Runnable(){

                public void run() {
                    c.consumeInput(ExtendedAsyncNHttpServiceHandler.this);
                }
            };
            if (executor instanceof ScheduledExecutorService) {
                ((ScheduledExecutorService)executor).schedule(runner, 0L, TimeUnit.MILLISECONDS);
            } else {
                executor.execute(runner);
            }
        }
    }

    protected void closeConnection(NHttpConnection conn, Throwable cause) {
        AsyncNHttpServiceHandler.ServerConnState state = (AsyncNHttpServiceHandler.ServerConnState)conn.getContext().getAttribute("http.nio.conn-state");
        try {
            state.finishOutput();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        super.closeConnection(conn, cause);
    }

    protected void shutdownConnection(NHttpConnection conn, Throwable cause) {
        AsyncNHttpServiceHandler.ServerConnState state = (AsyncNHttpServiceHandler.ServerConnState)conn.getContext().getAttribute("http.nio.conn-state");
        try {
            state.finishOutput();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        super.shutdownConnection(conn, cause);
    }
}

