/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.protocol;

import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

public class SynchronizedHttpProcessor
implements HttpProcessor {
    private final CopyOnWriteArrayList<HttpRequestInterceptor> requestInterceptors = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<HttpResponseInterceptor> responseInterceptors = new CopyOnWriteArrayList();

    public void addInterceptor(HttpRequestInterceptor interceptor) {
        this.requestInterceptors.add(interceptor);
    }

    public void addInterceptor(HttpResponseInterceptor interceptor) {
        this.responseInterceptors.add(interceptor);
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        for (HttpRequestInterceptor interceptor : this.requestInterceptors) {
            interceptor.process(request, context);
        }
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        for (HttpResponseInterceptor interceptor : this.responseInterceptors) {
            interceptor.process(response, context);
        }
    }

    public void removeInterceptor(HttpRequestInterceptor interceptor) {
        this.requestInterceptors.remove(interceptor);
    }

    public void removeInterceptor(HttpResponseInterceptor interceptor) {
        this.responseInterceptors.remove(interceptor);
    }
}

