/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.reactor;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.limewire.http.reactor.HttpIOSession;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.util.BufferUtils;

public class HttpChannel
implements ByteChannel,
ChannelReadObserver,
ChannelWriter {
    private static final Log LOG = LogFactory.getLog(HttpChannel.class);
    private final HttpIOSession session;
    private final IOEventDispatch eventDispatch;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private InterestReadableByteChannel readSource;
    private volatile InterestWritableByteChannel writeSource;
    private boolean writeInterest;
    private boolean readInterest;
    private ByteBuffer methodBuffer;
    private volatile boolean pendingClose = false;

    public HttpChannel(HttpIOSession session, IOEventDispatch eventDispatch, String method) {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        if (eventDispatch == null) {
            throw new IllegalArgumentException("eventDispatch must not be null");
        }
        this.session = session;
        this.eventDispatch = eventDispatch;
        if (method != null) {
            this.methodBuffer = ByteBuffer.wrap(method.getBytes());
        }
    }

    public HttpChannel(HttpIOSession session, IOEventDispatch eventDispatch) {
        this(session, eventDispatch, null);
    }

    public int read(ByteBuffer buffer) throws IOException {
        if (this.methodBuffer != null) {
            int read = BufferUtils.transfer(this.methodBuffer, buffer, false);
            if (this.methodBuffer.hasRemaining()) {
                return read;
            }
            this.methodBuffer = null;
            return read + this.readSource.read(buffer);
        }
        return this.readSource.read(buffer);
    }

    public void close() throws IOException {
        this.shutdown();
    }

    public void closeWhenBufferedOutputHasBeenFlushed() {
        InterestWritableByteChannel source = this.writeSource;
        if (source != null) {
            if (!source.hasBufferedOutput()) {
                this.session.shutdown();
            } else {
                this.pendingClose = true;
                this.requestWrite(true);
            }
        } else {
            this.session.shutdown();
        }
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    public int write(ByteBuffer buffer) throws IOException {
        return this.writeSource.write(buffer);
    }

    public void handleRead() throws IOException {
        if (!this.readInterest) {
            LOG.error("Unexpected call to HttpChannel.handleRead(), turning read interest back off");
            this.readSource.interestRead(false);
            return;
        }
        this.eventDispatch.inputReady(this.session);
    }

    public void handleIOException(IOException e) {
        LOG.error("Unexpected exception", e);
    }

    public void shutdown() {
        if (!this.closed.getAndSet(true)) {
            this.session.getIoExecutor().execute(new Runnable(){

                public void run() {
                    HttpChannel.this.eventDispatch.disconnected(HttpChannel.this.session);
                }
            });
        }
    }

    public InterestReadableByteChannel getReadChannel() {
        return this.readSource;
    }

    public void setReadChannel(InterestReadableByteChannel source) {
        this.readSource = source;
        if (this.readSource != null) {
            this.readSource.interestRead(this.readInterest);
        }
    }

    public synchronized InterestWritableByteChannel getWriteChannel() {
        return this.writeSource;
    }

    public synchronized void setWriteChannel(InterestWritableByteChannel channel) {
        this.writeSource = channel;
        if (this.writeSource != null) {
            this.writeSource.interestWrite(this, this.writeInterest);
        }
    }

    public boolean handleWrite() throws IOException {
        if (this.pendingClose) {
            if (!this.writeSource.hasBufferedOutput()) {
                this.session.shutdown();
            }
            return false;
        }
        if (!this.writeInterest) {
            return false;
        }
        this.eventDispatch.outputReady(this.session);
        return this.session.hasBufferedOutput();
    }

    public void requestRead(boolean status) {
        if (this.pendingClose) {
            return;
        }
        this.readInterest = status;
        if (this.readSource != null) {
            this.readSource.interestRead(status);
        }
    }

    public void requestWrite(boolean status) {
        if (this.pendingClose) {
            status = true;
        }
        this.writeInterest = status;
        if (this.writeSource != null) {
            this.writeSource.interestWrite(this, status);
        }
    }

    public boolean isWriteInterest() {
        return this.writeInterest;
    }

    public boolean isReadInterest() {
        return this.readInterest;
    }
}

