/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.reactor;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.apache.http.impl.nio.DefaultClientIOEventDispatch;
import org.apache.http.impl.nio.reactor.SessionRequestImpl;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.http.reactor.HttpChannel;
import org.limewire.http.reactor.HttpIOSession;
import org.limewire.net.SocketsManager;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.NBSocket;
import org.limewire.nio.observer.ConnectObserver;

public class LimeConnectingIOReactor
implements ConnectingIOReactor {
    public static final String IO_SESSION_KEY = "org.limewire.iosession";
    private final HttpParams params;
    protected volatile IOEventDispatch eventDispatch = null;
    private final Executor ioExecutor;
    private final SocketsManager socketsManager;
    private static final String NHTTP_CONN = "NHTTP_CONN";

    public LimeConnectingIOReactor(HttpParams params, Executor ioExecutor, SocketsManager socketsManager) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        this.params = params;
        this.ioExecutor = ioExecutor;
        this.socketsManager = socketsManager;
    }

    public void execute(IOEventDispatch eventDispatch) throws IOException {
        if (!(eventDispatch instanceof DefaultClientIOEventDispatch)) {
            throw new IllegalArgumentException("Event dispatch must be of type DefaultClientIOEventDispatch");
        }
        this.eventDispatch = eventDispatch;
    }

    public SessionRequest connect(SocketAddress remoteAddress, SocketAddress localAddress, final Object attachment, SessionRequestCallback callback) {
        final SessionRequestImpl sessionRequest = new SessionRequestImpl(remoteAddress, localAddress, attachment, callback);
        sessionRequest.setConnectTimeout(HttpConnectionParams.getConnectionTimeout(this.params));
        try {
            NBSocket socket = (NBSocket)this.socketsManager.create(SocketsManager.ConnectType.PLAIN);
            this.socketsManager.connect(socket, (InetSocketAddress)localAddress, (InetSocketAddress)remoteAddress, sessionRequest.getConnectTimeout(), new ConnectObserver(){

                public void handleConnect(Socket socket) throws IOException {
                    LimeConnectingIOReactor.this.prepareSocket((AbstractNBSocket)socket, attachment, sessionRequest);
                }

                public void handleIOException(IOException iox) {
                    sessionRequest.failed(iox);
                }

                public void shutdown() {
                    sessionRequest.failed(new IOException("couldn't connect"));
                }
            }, SocketsManager.ConnectType.PLAIN);
        }
        catch (IOException iox) {
            sessionRequest.failed(iox);
        }
        return sessionRequest;
    }

    protected void prepareSocket(AbstractNBSocket socket, Object attachment, SessionRequestImpl sessionRequest) throws IOException {
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(this.params));
        int linger = HttpConnectionParams.getLinger(this.params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
        HttpIOSession session = new HttpIOSession(socket, this.ioExecutor);
        session.setAttribute("http.session.attachment", attachment);
        session.setSocketTimeout(HttpConnectionParams.getSoTimeout(this.params));
        HttpChannel channel = new HttpChannel(session, this.eventDispatch, null);
        session.setHttpChannel(channel);
        this.eventDispatch.connected(session);
        sessionRequest.completed(session);
        NHttpConnection conn = (NHttpConnection)session.getAttribute(NHTTP_CONN);
        assert (conn != null);
        conn.getContext().setAttribute(IO_SESSION_KEY, session);
        socket.setReadObserver(channel);
        socket.setWriteObserver(channel);
    }

    public IOReactorStatus getStatus() {
        throw new UnsupportedOperationException();
    }

    public void shutdown() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void shutdown(long gracePeriod) throws IOException {
        throw new UnsupportedOperationException();
    }
}

