/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.inspection;

import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectableForSize;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectionUtils {
    public static Object inspectValue(String encodedField, Injector injector) throws InspectionException {
        try {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            return InspectionUtils.inspect(InspectionUtils.getTargetObject(encodedField, annotations, injector), annotations);
        }
        catch (Throwable e) {
            if (e instanceof InspectionException) {
                throw (InspectionException)e;
            }
            throw new InspectionException(e);
        }
    }

    private static Object getTargetObject(String encodedField, List<Annotation> annotations, Injector injector) throws Throwable {
        Object instance;
        StringTokenizer t;
        if (encodedField.contains(":")) {
            return InspectionUtils.getTargetStaticObject(encodedField, annotations);
        }
        Class<?> lookup = null;
        Class<?> container = null;
        if (encodedField.contains("|")) {
            StringTokenizer tokenizer = new StringTokenizer(encodedField, "|");
            lookup = Class.forName(tokenizer.nextToken());
            encodedField = tokenizer.nextToken();
        }
        if ((t = new StringTokenizer(encodedField, ",")).countTokens() < 2) {
            throw new InspectionException();
        }
        Class<?> clazz = Class.forName(t.nextToken());
        if (lookup != null) {
            container = clazz;
            if (clazz.getEnclosingClass() == null) {
                throw new InspectionException("must be a container!");
            }
            if (!lookup.isAssignableFrom(clazz.getEnclosingClass())) {
                throw new InspectionException("wrong container!");
            }
        } else {
            container = clazz;
            if (clazz.getEnclosingClass() != null) {
                lookup = clazz.getEnclosingClass();
            }
        }
        if (lookup == null) {
            if (container.getAnnotation(Singleton.class) == null && !container.isInterface()) {
                throw new InspectionException("must have singleton annotation or be interface!");
            }
            instance = injector.getInstance(container);
        } else {
            if (lookup.getAnnotation(Singleton.class) == null && !lookup.isInterface()) {
                throw new InspectionException("lookup class must be singleton or interface!");
            }
            if (container.getAnnotation(InspectableContainer.class) == null) {
                throw new InspectionException("container must be annotated with InspectableContainer");
            }
            Object enclosingObj = injector.getInstance(lookup);
            Constructor<?>[] constructors = container.getDeclaredConstructors();
            if (constructors.length != 1) {
                throw new InspectionException("wrong constructors length: " + constructors.length);
            }
            Class<?>[] parameters = constructors[0].getParameterTypes();
            if (parameters.length != 1 || !lookup.isAssignableFrom(parameters[0])) {
                throw new InspectionException("wrong parameter count or type for constructor");
            }
            constructors[0].setAccessible(true);
            instance = constructors[0].newInstance(enclosingObj);
        }
        while (t.hasMoreTokens()) {
            instance = InspectionUtils.getValue(instance, t.nextToken(), annotations);
        }
        return instance;
    }

    private static Object getTargetStaticObject(String encodedField, List<Annotation> annotations) throws Throwable {
        StringTokenizer t = new StringTokenizer(encodedField, ":,");
        if (t.countTokens() < 2) {
            throw new InspectionException();
        }
        Object instance = InspectionUtils.getValue(Class.forName(t.nextToken()), t.nextToken(), annotations);
        while (t.hasMoreTokens()) {
            instance = InspectionUtils.getValue(instance, t.nextToken(), annotations);
        }
        return instance;
    }

    private static Object inspect(Object o, List<Annotation> annotations) throws Exception {
        if (o instanceof Inspectable) {
            Inspectable i = (Inspectable)o;
            return i.inspect();
        }
        for (Annotation a : annotations) {
            if (a instanceof InspectablePrimitive) {
                return String.valueOf(o);
            }
            if (!(a instanceof InspectableForSize)) continue;
            Method m = o.getClass().getMethod("size", new Class[0]);
            m.setAccessible(true);
            return m.invoke(o, new Object[0]).toString();
        }
        throw new InspectionException();
    }

    private static Object getValue(Object instance, String fieldName, List<Annotation> annotations) throws IllegalAccessException, NoSuchFieldException {
        Field field = instance instanceof Class ? InspectionUtils.getFieldImpl((Class)instance, fieldName) : InspectionUtils.getFieldImpl(instance.getClass(), fieldName);
        field.setAccessible(true);
        if (annotations != null) {
            annotations.clear();
            for (Annotation a : field.getAnnotations()) {
                annotations.add(a);
            }
        }
        return field.get(instance);
    }

    private static Field getFieldImpl(Class thisClass, String fieldName) throws NoSuchFieldException {
        if (thisClass == null) {
            throw new NoSuchFieldException("Invalid field : " + fieldName);
        }
        try {
            return thisClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return InspectionUtils.getFieldImpl(thisClass.getSuperclass(), fieldName);
        }
    }
}

