/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.security.MessageDigest;
import java.util.zip.CRC32;

public class CRC32MessageDigest
extends MessageDigest {
    private final CRC32 crc = new CRC32();

    public CRC32MessageDigest() {
        super("CRC32");
    }

    protected int engineGetDigestLength() {
        return 4;
    }

    protected byte[] engineDigest() {
        long value = this.crc.getValue();
        byte[] digest = new byte[]{(byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
        return digest;
    }

    protected void engineReset() {
        this.crc.reset();
    }

    protected void engineUpdate(byte input) {
        this.crc.update(input & 0xFF);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.crc.update(input, offset, len);
    }
}

