/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;

public class ConnectableImpl
implements Connectable {
    private final IpPort ipPort;
    private final boolean tlsCapable;

    public ConnectableImpl(IpPort ipPort, boolean tlsCapable) {
        this.ipPort = ipPort;
        this.tlsCapable = tlsCapable;
    }

    public ConnectableImpl(InetSocketAddress addr, boolean tlsCapable) {
        this(new IpPortImpl(addr), tlsCapable);
    }

    public ConnectableImpl(String host, int port, boolean tlsCapable) throws UnknownHostException {
        this(new IpPortImpl(host, port), tlsCapable);
    }

    public ConnectableImpl(Connectable connectable) {
        this(new IpPortImpl(connectable.getInetSocketAddress(), connectable.getAddress()), connectable.isTLSCapable());
    }

    public boolean isTLSCapable() {
        return this.tlsCapable;
    }

    public String getAddress() {
        return this.ipPort.getAddress();
    }

    public InetAddress getInetAddress() {
        return this.ipPort.getInetAddress();
    }

    public int getPort() {
        return this.ipPort.getPort();
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.ipPort.getInetSocketAddress();
    }

    public String toString() {
        return this.ipPort + ", tlsCapable: " + this.tlsCapable;
    }
}

