/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.EnumMap;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.limewire.i18n.I18nMarker;
import org.limewire.service.ErrorService;
import org.limewire.service.MessageService;
import org.limewire.util.FileUtils;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    private static final EnumMap<ErrorType, EnumMap<DetailErrorType, String>> errorDescs = new EnumMap(ErrorType.class);

    public static boolean handleException(IOException ioe, ErrorType errorType) {
        for (Throwable e = ioe; e != null; e = e.getCause()) {
            String msg = e.getMessage();
            if (msg == null) continue;
            msg = msg.toLowerCase();
            DetailErrorType detailType = null;
            if (StringUtils.contains(msg, "no space left") || StringUtils.contains(msg, "not enough space")) {
                detailType = DetailErrorType.DISK_FULL;
            } else if (StringUtils.contains(msg, "being used by another process") || StringUtils.contains(msg, "with a user-mapped section open")) {
                detailType = DetailErrorType.FILE_LOCKED;
            } else if (StringUtils.contains(msg, "access is denied") || StringUtils.contains(msg, "permission denied")) {
                detailType = DetailErrorType.NO_PRIVS;
            } else if (StringUtils.contains(msg, "invalid argument")) {
                detailType = DetailErrorType.BAD_CHARS;
            }
            if (detailType == null) continue;
            MessageService.showError(errorDescs.get((Object)errorType).get((Object)detailType));
            return true;
        }
        return false;
    }

    public static IOException getIOException(String message, Throwable cause) {
        IOException ioException = new IOException(message);
        ioException.initCause(cause);
        return ioException;
    }

    public static String readWord(InputStream in, int maxSize) throws IOException {
        char[] buf = new char[maxSize];
        int i = 0;
        try {
            int got;
            while ((got = in.read()) >= 0) {
                if ((char)got != ' ') {
                    if (i < maxSize) {
                        buf[i++] = (char)got;
                        continue;
                    }
                    throw new IOException("could not read word");
                }
                return new String(buf, 0, i);
            }
            throw new IOException("unexpected end of file");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IOException("unexpected aioobe");
        }
    }

    public static String readLargestWord(InputStream in, int maxSize) throws IOException {
        char[] buf = new char[maxSize];
        int i = 0;
        try {
            block5: {
                block6: {
                    while (true) {
                        int got;
                        if ((got = in.read()) == -1) {
                            if (i == 0) {
                                throw new IOException("could not read any word.");
                            }
                            return new String(buf, 0, i);
                        }
                        if (got < 0) break block5;
                        if ((char)got == ' ') break block6;
                        if (i >= maxSize) break;
                        buf[i++] = (char)got;
                    }
                    throw new IOException("could not read word");
                }
                return new String(buf, 0, i);
            }
            throw new IOException("unknown got amount");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IOException("unexpected aioobe");
        }
    }

    public static long ensureSkip(InputStream in, long length) throws IOException {
        long skipped;
        long current;
        for (skipped = 0L; skipped < length; skipped += current) {
            current = in.skip(length - skipped);
            if (current != -1L && current != 0L) continue;
            throw new EOFException("eof");
        }
        return skipped;
    }

    public static void close(Closeable closeable) {
        FileUtils.close(closeable);
    }

    public static void close(Iterable<? extends Closeable> closeables) {
        if (closeables != null) {
            for (Closeable closeable : closeables) {
                IOUtils.close(closeable);
            }
        }
    }

    public static void flush(Flushable flushable) {
        FileUtils.flush(flushable);
    }

    public static void close(Socket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                IOUtils.close(s.getInputStream());
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                IOUtils.close(s.getOutputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(ServerSocket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Deflater deflater) {
        if (deflater != null) {
            deflater.end();
        }
    }

    public static void close(Inflater inflater) {
        if (inflater != null) {
            inflater.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] deflate(byte[] data) {
        byte[] byArray;
        DeflaterOutputStream dos = null;
        Deflater def = null;
        try {
            def = new Deflater();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dos = new DeflaterOutputStream((OutputStream)baos, def);
            ((OutputStream)dos).write(data, 0, data.length);
            ((OutputStream)dos).close();
            byArray = baos.toByteArray();
            IOUtils.close(dos);
        }
        catch (IOException impossible) {
            ErrorService.error(impossible);
            byte[] byArray2 = null;
            return byArray2;
        }
        finally {
            IOUtils.close(dos);
            IOUtils.close(def);
        }
        IOUtils.close(def);
        return byArray;
    }

    public static byte[] inflate(byte[] data) throws IOException {
        byte[] byArray;
        InflaterInputStream in = null;
        Inflater inf = null;
        try {
            int read;
            inf = new Inflater();
            in = new InflaterInputStream(new ByteArrayInputStream(data), inf);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[64];
            while ((read = ((InputStream)in).read(buf, 0, buf.length)) != -1) {
                out.write(buf, 0, read);
            }
            byArray = out.toByteArray();
        }
        catch (OutOfMemoryError oome) {
            try {
                throw new IOException(oome.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                IOUtils.close(inf);
                throw throwable;
            }
        }
        IOUtils.close(in);
        IOUtils.close(inf);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFully(InputStream in) throws IOException {
        ByteArrayOutputStream bos = null;
        try {
            int read;
            bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((read = in.read(buffer)) != -1) {
                bos.write(buffer, 0, read);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.close(bos);
            IOUtils.close(in);
        }
    }

    static {
        for (ErrorType type : ErrorType.values()) {
            errorDescs.put(type, new EnumMap(DetailErrorType.class));
        }
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.DISK_FULL, I18nMarker.marktr("LimeWire was unable to write a necessary file because your hard drive is full. To continue using LimeWire you must free up space on your hard drive."));
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.FILE_LOCKED, I18nMarker.marktr("LimeWire was unable to open a necessary file because another program has locked the file. LimeWire may act unexpectedly until this file is released."));
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.NO_PRIVS, I18nMarker.marktr("LimeWire was unable to write a necessary file because you do not have the necessary permissions. Your preferences may not be maintained the next time you start LimeWire, or LimeWire may behave in unexpected ways."));
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.BAD_CHARS, I18nMarker.marktr("LimeWire cannot open a necessary file because the filename contains characters which are not supported by your operating system. LimeWire may behave in unexpected ways."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.DISK_FULL, I18nMarker.marktr("LimeWire cannot download the selected file because your hard drive is full. To download more files, you must free up space on your hard drive."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.FILE_LOCKED, I18nMarker.marktr("LimeWire was unable to download the selected file because another program is using the file. Please close the other program and retry the download."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.NO_PRIVS, I18nMarker.marktr("LimeWire was unable to create or continue writing an incomplete file for the selected download because you do not have permission to write files to the incomplete folder. To continue using LimeWire, please choose a different Save Folder."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.BAD_CHARS, I18nMarker.marktr("LimeWire was unable to open the incomplete file for the selected download because the filename contains characters which are not supported by your operating system."));
        for (ErrorType type : ErrorType.values()) {
            assert (errorDescs.get((Object)type) != null);
            assert (errorDescs.get((Object)type).size() == DetailErrorType.values().length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DetailErrorType {
        DISK_FULL,
        FILE_LOCKED,
        NO_PRIVS,
        BAD_CHARS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorType {
        GENERIC,
        DOWNLOAD;

    }
}

