/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortForSelf;
import org.limewire.io.LocalSocketAddressProvider;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

@Singleton
class NetworkInstanceUtilsImpl
implements NetworkInstanceUtils {
    private final LocalSocketAddressProvider localSocketAddressProvider;
    private final IpPortForSelf ipPortForSelf;

    @Inject
    NetworkInstanceUtilsImpl(LocalSocketAddressProvider localSocketAddressProvider, IpPortForSelf ipPortForSelf) {
        this.localSocketAddressProvider = localSocketAddressProvider;
        this.ipPortForSelf = ipPortForSelf;
    }

    public boolean isMe(String host, int port) {
        try {
            return this.isMe(InetAddress.getByName(host).getAddress(), port);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public boolean isMe(byte[] address, int port) {
        if (NetworkUtils.isLoopbackAddress(address)) {
            return port == this.localSocketAddressProvider.getLocalPort();
        }
        byte[] local = this.localSocketAddressProvider.getLocalAddress();
        return port == this.localSocketAddressProvider.getLocalPort() && Arrays.equals(address, local);
    }

    public boolean isMe(IpPort me) {
        if (me == this.ipPortForSelf) {
            return true;
        }
        return this.isMe(me.getInetAddress().getAddress(), me.getPort());
    }

    public boolean isVeryCloseIP(byte[] addr0, byte[] addr1) {
        if (!this.isPrivateAddress(addr0)) {
            return false;
        }
        return NetworkUtils.isVeryCloseIP(addr0, addr1);
    }

    public boolean isVeryCloseIP(InetAddress addr) {
        return this.isVeryCloseIP(addr.getAddress());
    }

    public boolean isVeryCloseIP(byte[] addr) {
        return this.isVeryCloseIP(this.localSocketAddressProvider.getLocalAddress(), addr);
    }

    public boolean isPrivate() {
        return this.isPrivateAddress(this.localSocketAddressProvider.getLocalAddress());
    }

    public boolean isPrivateAddress(InetAddress address) {
        if (!this.localSocketAddressProvider.isLocalAddressPrivate()) {
            return false;
        }
        return NetworkUtils.isPrivateAddress(address);
    }

    public boolean isPrivateAddress(byte[] address) {
        if (!this.localSocketAddressProvider.isLocalAddressPrivate()) {
            return false;
        }
        return NetworkUtils.isPrivateAddress(address);
    }

    public boolean isPrivateAddress(String address) {
        try {
            return this.isPrivateAddress(InetAddress.getByName(address));
        }
        catch (UnknownHostException uhe) {
            return true;
        }
    }

    public boolean isPrivateAddress(SocketAddress address) {
        return this.isPrivateAddress(((InetSocketAddress)address).getAddress());
    }

    public boolean isValidExternalIpPort(IpPort addr) {
        return NetworkUtils.isValidExternalIpPort(addr) && !this.isPrivateAddress(addr.getInetAddress());
    }
}

