/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.security.MessageDigest;
import org.limewire.io.CRC32MessageDigest;

public class SecureInputStream
extends FilterInputStream {
    private final MessageDigest md;
    private final byte[] buffer;
    private int pos = 0;
    private int length = -1;

    public SecureInputStream(InputStream in) throws IOException {
        this(in, new CRC32MessageDigest());
    }

    public SecureInputStream(InputStream in, MessageDigest md) throws IOException {
        super(in);
        if (md == null) {
            throw new NullPointerException("MessageDigest is null");
        }
        int length = 0;
        for (int i = 0; i < 4; ++i) {
            int b = in.read();
            if (b < 0) {
                throw new EOFException("Couldn't read the length of the header");
            }
            length = length << 8 | b & 0xFF;
        }
        if (length <= 0 || length >= 512) {
            throw new StreamCorruptedException("Invalid length of the header: " + length);
        }
        byte[] header = new byte[length];
        for (int i = 0; i < header.length; ++i) {
            int b = in.read();
            if (b < 0) {
                throw new EOFException("Couldn't read the header");
            }
            header[i] = (byte)(b & 0xFF);
        }
        md.update(header, 0, header.length);
        byte[] actual = md.digest();
        for (int i = 0; i < actual.length; ++i) {
            int b = in.read();
            if (b < 0) {
                throw new EOFException("Couldn't read the checksum of length " + actual.length);
            }
            if (actual[i] == (byte)(b & 0xFF)) continue;
            throw new StreamCorruptedException("Header checksums do not match");
        }
        String algorithm = null;
        int digestLength = 0;
        int blockSize = 0;
        ByteArrayInputStream bias = new ByteArrayInputStream(header);
        DataInputStream dis = new DataInputStream(bias);
        algorithm = dis.readUTF();
        digestLength = dis.readInt();
        blockSize = dis.readInt();
        dis.close();
        if (!algorithm.equals(md.getAlgorithm())) {
            throw new StreamCorruptedException("Expected a MessageDigest of type " + algorithm + " but is " + md.getAlgorithm());
        }
        if (digestLength != md.getDigestLength()) {
            throw new StreamCorruptedException("Expected a MessageDigest with length " + digestLength + " but is " + md.getDigestLength());
        }
        md.reset();
        this.md = md;
        this.buffer = new byte[blockSize];
    }

    public int getBlockSize() {
        return this.buffer.length;
    }

    public MessageDigest getMessageDigest() {
        return this.md;
    }

    private int refill() throws IOException {
        int r;
        assert (this.pos >= this.length);
        this.pos = 0;
        this.length = 0;
        this.md.reset();
        while (this.length < this.buffer.length && (r = this.in.read()) >= 0) {
            this.buffer[this.length++] = (byte)(r & 0xFF);
        }
        if (this.length == 0) {
            return -1;
        }
        int digestLength = this.md.getDigestLength();
        this.length -= digestLength;
        if (this.length <= 0) {
            throw new StreamCorruptedException("Illegal payload length: " + this.length);
        }
        this.md.update(this.buffer, 0, this.length);
        byte[] digest = this.md.digest();
        assert (digest.length == digestLength);
        for (int i = 0; i < digest.length; ++i) {
            if (digest[i] == this.buffer[this.length + i]) continue;
            throw new StreamCorruptedException("Checksums do not match");
        }
        return this.length;
    }

    public int read() throws IOException {
        if (this.pos >= this.length) {
            this.refill();
            if (this.pos >= this.length) {
                return -1;
            }
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int total;
        int copy;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        for (total = 0; total < len; total += copy) {
            if (this.pos >= this.length) {
                this.refill();
                if (this.pos >= this.length) break;
            }
            copy = Math.min(this.length - this.pos, len - total);
            System.arraycopy(this.buffer, this.pos, b, off + total, copy);
            this.pos += copy;
        }
        return total > 0 ? total : -1;
    }
}

