/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.io.IOException;
import java.io.OutputStream;
import org.limewire.io.BandwidthThrottle;

public class ThrottledOutputStream
extends OutputStream {
    private OutputStream _delegate;
    private BandwidthThrottle _throttle;

    public ThrottledOutputStream(OutputStream delegate, BandwidthThrottle throttle) {
        this._delegate = delegate;
        this._throttle = throttle;
    }

    public void write(int b) throws IOException {
        int allow = this._throttle.request(1);
        assert (allow == 1);
        this._delegate.write(b);
    }

    public void write(byte[] data, int offset, int totalLength) throws IOException {
        while (totalLength > 0) {
            int length = this._throttle.request(totalLength);
            assert (length + offset <= data.length);
            this._delegate.write(data, offset, length);
            totalLength -= length;
            offset += length;
        }
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void flush() throws IOException {
        this._delegate.flush();
    }

    public void close() throws IOException {
        this._delegate.flush();
    }
}

