/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.lifecycle;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.lifecycle.ServiceStage;
import org.limewire.lifecycle.StagedRegisterBuilder;
import org.limewire.lifecycle.StagedRegisterBuilderImpl;

@Singleton
class ServiceRegistryImpl
implements ServiceRegistry {
    private final List<StagedRegisterBuilderImpl> builders = new ArrayList<StagedRegisterBuilderImpl>();
    private final Map<Object, List<ServiceHolder>> services = new HashMap<Object, List<ServiceHolder>>();
    private final List<ServiceHolder> startedServices = new ArrayList<ServiceHolder>();

    ServiceRegistryImpl() {
    }

    public void initialize() {
        Iterator<StagedRegisterBuilderImpl> iter = this.builders.iterator();
        while (iter.hasNext()) {
            List<ServiceHolder> servicesInStage;
            StagedRegisterBuilderImpl builder = iter.next();
            Object stage = builder.getCustomStage();
            if (stage == null) {
                stage = builder.getStage();
            }
            if ((servicesInStage = this.services.get(stage)) == null) {
                servicesInStage = new ArrayList<ServiceHolder>();
                this.services.put(stage, servicesInStage);
            }
            servicesInStage.add(new ServiceHolder(builder.getService()));
            iter.remove();
        }
        for (ServiceStage stage : this.getStagesInOrder()) {
            if (this.services.get((Object)stage) == null) continue;
            for (ServiceHolder service : this.services.get((Object)stage)) {
                service.init();
            }
        }
        for (Map.Entry<Object, List<ServiceHolder>> entry : this.services.entrySet()) {
            if (entry.getKey().getClass() == ServiceStage.class || entry.getValue() == null) continue;
            for (ServiceHolder service : entry.getValue()) {
                service.init();
            }
        }
    }

    public void start(Object stage) {
        this.initialize();
        this.startStage(stage);
    }

    public void start() {
        this.initialize();
        for (ServiceStage stage : this.getStagesInOrder()) {
            this.startStage((Object)stage);
        }
    }

    private void startStage(Object stage) {
        List<ServiceHolder> servicedStages = this.services.get(stage);
        if (servicedStages != null) {
            Iterator<ServiceHolder> iter = servicedStages.iterator();
            while (iter.hasNext()) {
                ServiceHolder service = iter.next();
                service.start();
                this.startedServices.add(service);
                iter.remove();
            }
        }
    }

    public void stop() {
        for (int i = this.startedServices.size() - 1; i >= 0; --i) {
            this.startedServices.get(i).stop();
            this.startedServices.remove(i);
        }
    }

    public StagedRegisterBuilder register(Service service) {
        StagedRegisterBuilderImpl builder = new StagedRegisterBuilderImpl(service);
        this.builders.add(builder);
        return builder;
    }

    ServiceStage[] getStagesInOrder() {
        return new ServiceStage[]{ServiceStage.EARLY, ServiceStage.NORMAL, ServiceStage.LATE};
    }

    private static class ServiceHolder {
        private final Service service;
        private boolean initted;
        private boolean started;
        private boolean stopped;

        public ServiceHolder(Service service) {
            this.service = service;
        }

        void init() {
            if (!this.initted) {
                this.initted = true;
                this.service.initialize();
            }
        }

        void start() {
            if (!this.started) {
                this.started = true;
                this.service.start();
            }
        }

        void stop() {
            if (!this.stopped) {
                this.stopped = true;
                this.service.stop();
            }
        }
    }
}

