/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.lws.server;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.limewire.lws.server.LWSDispatcherSupport;
import org.limewire.lws.server.LWSSenderOfMessagesToServer;
import org.limewire.lws.server.LWSServerUtil;
import org.limewire.lws.server.StringCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LWSDispatcherImpl
extends LWSDispatcherSupport {
    private final LWSSenderOfMessagesToServer sender;
    private String publicKey;
    private String privateKey;
    private String sharedKey;

    public LWSDispatcherImpl(LWSSenderOfMessagesToServer sender) {
        this.sender = sender;
    }

    @Override
    public void deauthenticate() {
        this.publicKey = null;
        this.privateKey = null;
        this.sharedKey = null;
    }

    @Override
    protected final LWSDispatcherSupport.Handler[] createHandlers() {
        return new LWSDispatcherSupport.Handler[]{new StartCom(), new Authenticate(), new Detatch(), new Msg()};
    }

    @Override
    protected final boolean isAuthenticated() {
        return this.publicKey != null && this.privateKey != null && this.sharedKey != null;
    }

    @Override
    protected Map<String, String> getArgs(String request) {
        if (request == null || request.length() == 0) {
            return Collections.emptyMap();
        }
        int ihuh = request.indexOf(63);
        if (ihuh == -1) {
            return Collections.emptyMap();
        }
        String rest = request.substring(ihuh + 1);
        return LWSServerUtil.parseArgs(rest);
    }

    @Override
    protected String getCommand(String request) {
        char[] cs;
        int iprefix = request.indexOf("store:");
        String res = iprefix == -1 ? request : request.substring(iprefix + "store:".length());
        for (char c : cs = new char[]{'#', '?'}) {
            int id = res.indexOf(c);
            if (id == -1) continue;
            res = res.substring(0, id);
        }
        return res;
    }

    final String getPublicKey() {
        return this.publicKey;
    }

    final String getPrivateKey() {
        return this.privateKey;
    }

    final String getSharedKey() {
        return this.sharedKey;
    }

    private void regenerateKeys() {
        this.publicKey = LWSServerUtil.generateKey();
        this.privateKey = LWSServerUtil.generateKey();
        this.sharedKey = LWSServerUtil.generateKey();
        this.note("public key  : {0}", this.publicKey);
        this.note("private key : {0}", this.privateKey);
        this.note("shared key  : {0}", this.sharedKey);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Msg
    extends HandlerWithCallbackWithPrivateKey {
        Msg() {
        }

        @Override
        protected void handleRest(String privateKey, String herSharedKey, Map<String, String> args, StringCallback cb) {
            String cmd = args.get("command");
            if (cmd == null) {
                cb.process(this.report("missing.command.parameter"));
                return;
            }
            if (LWSDispatcherImpl.this.getCommandReceiver() != null) {
                HashMap<String, String> newArgs = new HashMap<String, String>(args);
                String newCmd = LWSServerUtil.addURLEncodedArguments(cmd, newArgs);
                String res = LWSDispatcherImpl.this.getCommandReceiver().receiveCommand(newCmd, newArgs);
                cb.process(res);
                return;
            }
            cb.process("no.dispatcher");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Detatch
    extends LWSDispatcherSupport.HandlerWithCallback {
        Detatch() {
            super(LWSDispatcherImpl.this);
        }

        @Override
        protected void handleRest(Map<String, String> args, StringCallback cb) {
            LWSDispatcherImpl.this.privateKey = null;
            LWSDispatcherImpl.this.publicKey = null;
            LWSDispatcherImpl.this.sharedKey = null;
            LWSDispatcherImpl.this.notifyConnectionListeners(false);
            cb.process("ok");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Authenticate
    extends HandlerWithCallbackWithPrivateKey {
        Authenticate() {
        }

        @Override
        protected void handleRest(String privateKey, String sharedKey, Map<String, String> args, StringCallback cb) {
            LWSDispatcherImpl.this.notifyConnectionListeners(true);
            cb.process("ok");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StartCom
    extends LWSDispatcherSupport.HandlerWithCallback {
        StartCom() {
            super(LWSDispatcherImpl.this);
        }

        @Override
        protected void handleRest(Map<String, String> args, final StringCallback cb) {
            LWSDispatcherImpl.this.regenerateKeys();
            HashMap<String, String> sendArgs = new HashMap<String, String>();
            sendArgs.put("private", LWSDispatcherImpl.this.privateKey);
            sendArgs.put("public", LWSDispatcherImpl.this.publicKey);
            try {
                LWSDispatcherImpl.this.sender.sendMessageToServer("StoreKey", sendArgs, new StringCallback(){

                    public void process(String response) {
                        cb.process(response.indexOf("ok") != -1 ? LWSDispatcherImpl.this.publicKey + " " + LWSDispatcherImpl.this.sharedKey : "0");
                    }
                });
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class HandlerWithCallbackWithPrivateKey
    extends LWSDispatcherSupport.HandlerWithCallback {
        protected HandlerWithCallbackWithPrivateKey() {
            super(LWSDispatcherImpl.this);
        }

        @Override
        protected final void handleRest(Map<String, String> args, StringCallback cb) {
            String privateKey = LWSDispatcherImpl.this.getPrivateKey();
            if (privateKey == null) {
                cb.process(this.report("uninitialized.private.key"));
                return;
            }
            String herPrivateKey = args.get("private");
            if (herPrivateKey == null) {
                cb.process(this.report("missing.private.parameter"));
                return;
            }
            if (!herPrivateKey.equals(privateKey)) {
                cb.process(this.report("invalid.private.key"));
                return;
            }
            String sharedKey = LWSDispatcherImpl.this.getSharedKey();
            if (sharedKey == null) {
                cb.process(this.report("uninitialized.shared.key"));
                return;
            }
            String herSharedKey = args.get("shared");
            if (herSharedKey == null) {
                cb.process(this.report("missing.shared.parameter"));
                return;
            }
            if (!herSharedKey.equals(sharedKey)) {
                cb.process(this.report("invalid.shared.key"));
                return;
            }
            this.handleRest(herPrivateKey, herSharedKey, args, cb);
        }

        abstract void handleRest(String var1, String var2, Map<String, String> var3, StringCallback var4);
    }
}

