/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.lws.server;

import java.net.InetAddress;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.limewire.io.NetworkUtils;
import org.limewire.lws.server.LWSDispatcherSupport;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LWSServerUtil {
    private static final String ERROR_START = "ERROR:";
    static final Map<String, String> EMPTY_MAP_OF_STRING_X_STRING = new HashMap<String, String>();

    private LWSServerUtil() {
    }

    public static boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    public static Map<String, String> parseArgs(String rest) {
        if (LWSServerUtil.isEmpty(rest)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> res = new HashMap<String, String>(3);
        StringTokenizer st = new StringTokenizer(rest, "&", false);
        while (st.hasMoreTokens()) {
            String val;
            String key;
            String pair = st.nextToken();
            int ieq = pair.indexOf(61);
            if (ieq == -1) {
                key = pair;
                val = null;
            } else {
                key = pair.substring(0, ieq);
                val = pair.substring(ieq + 1);
            }
            res.put(key.trim(), val == null ? val : val.trim());
        }
        return res;
    }

    public static String createCookieDate() {
        SimpleDateFormat f = new SimpleDateFormat("E, dd-MM-yyyy kk:mm:ss");
        Date date = Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime();
        return f.format((Object)date) + " GMT";
    }

    static String simpleName(Class c) {
        String s = c.getName();
        int ilastDot = s.lastIndexOf(".");
        return ilastDot == -1 ? s : s.substring(ilastDot + 1);
    }

    public static String unwrapError(String line) {
        if (line.startsWith(ERROR_START)) {
            return line.substring(ERROR_START.length()).trim();
        }
        return null;
    }

    public static String wrapError(String error) {
        return ERROR_START + error;
    }

    public static String removeCallback(String res) {
        if (res == null) {
            return null;
        }
        String start = "(" + LWSDispatcherSupport.Constants.CALLBACK_QUOTE_STRING;
        String end = LWSDispatcherSupport.Constants.CALLBACK_QUOTE_STRING + ")";
        int istart = res.indexOf(start);
        if (istart == -1) {
            return res;
        }
        int iend = res.lastIndexOf(end);
        if (iend == -1) {
            return res;
        }
        return res.substring(istart + start.length(), iend);
    }

    private static boolean isValidKey(String key) {
        if (key == null || key.equals("")) {
            return false;
        }
        int I = key.length();
        for (int i = 0; i < I; ++i) {
            if (key.charAt(i) != '.') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPublicKey(String key) {
        return LWSServerUtil.isValidKey(key);
    }

    public static boolean isValidSharedKey(String key) {
        return LWSServerUtil.isValidKey(key);
    }

    public static boolean isValidPrivateKey(String key) {
        return LWSServerUtil.isValidKey(key);
    }

    public static String getIPAddress(InetAddress addr) {
        if (addr == null) {
            return null;
        }
        byte[] bs = addr.getAddress();
        return NetworkUtils.ip2string(bs);
    }

    public static String generateKey() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 10) {
            int r = 65 + (int)(Math.random() * 25.0);
            char c = (char)r;
            if (c == ';') continue;
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String addURLEncodedArguments(String cmd, Map<String, String> args) {
        if (cmd == null) {
            return null;
        }
        int ihuh = cmd.indexOf("?");
        if (ihuh == -1) {
            return cmd;
        }
        String newCmd = cmd.substring(0, ihuh);
        String tmpRest = cmd.substring(ihuh + 1);
        try {
            tmpRest = URLDecoder.decode(tmpRest, "UTF-8");
        }
        catch (Exception e) {
            ErrorService.error(e);
        }
        String rest = tmpRest;
        StringTokenizer st = new StringTokenizer(rest, "&", false);
        while (st.hasMoreTokens()) {
            String val;
            String key;
            String tok = st.nextToken();
            int ieq = tok.indexOf(61);
            if (ieq == -1) {
                key = tok;
                val = null;
            } else {
                key = tok.substring(0, ieq);
                val = tok.substring(ieq + 1);
            }
            args.put(key, val);
        }
        return newCmd;
    }

    public static boolean isError(String res) {
        return res != null && res.startsWith(ERROR_START);
    }
}

