/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.limewire.collection.PatriciaTrie;
import org.limewire.mojito.util.ArrayUtils;
import org.limewire.security.SecurityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KUID
implements Comparable<KUID>,
Serializable {
    private static final long serialVersionUID = 633717248208386374L;
    private static final Random GENERATOR = SecurityUtils.createSecureRandomNoBlock();
    public static final int LENGTH = 20;
    public static final int LENGTH_IN_BITS = 160;
    private static final int[] BITS = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    public static final KUID MINIMUM;
    public static final KUID MAXIMUM;
    private final byte[] id;
    private final int hashCode;
    public static final PatriciaTrie.KeyAnalyzer<KUID> KEY_ANALYZER;

    protected KUID(byte[] id) {
        if (id == null) {
            throw new NullPointerException("ID is null");
        }
        if (id.length != 20) {
            throw new IllegalArgumentException("ID must be 20 bytes long");
        }
        this.id = id;
        this.hashCode = Arrays.hashCode(id);
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.id, 0, this.id.length);
    }

    public boolean isBitSet(int bitIndex) {
        int index = bitIndex / BITS.length;
        int bit = bitIndex - index * BITS.length;
        return (this.id[index] & BITS[bit]) != 0;
    }

    public KUID set(int bit) {
        return this.set(bit, true);
    }

    public KUID unset(int bit) {
        return this.set(bit, false);
    }

    public KUID flip(int bit) {
        return this.set(bit, !this.isBitSet(bit));
    }

    private KUID set(int bitIndex, boolean set) {
        boolean isBitSet;
        int index = bitIndex / BITS.length;
        int bit = bitIndex - index * BITS.length;
        boolean bl = isBitSet = (this.id[index] & BITS[bit]) != 0;
        if (isBitSet != set) {
            byte[] id = this.getBytes();
            int n = index;
            id[n] = (byte)(id[n] ^ BITS[bit]);
            return new KUID(id);
        }
        return this;
    }

    public int bits() {
        int bits = 0;
        for (int i = 0; i < 160; ++i) {
            if (!this.isBitSet(i)) continue;
            ++bits;
        }
        return bits;
    }

    public int bitIndex(KUID nodeId) {
        boolean allNull = true;
        int bitIndex = 0;
        for (int i = 0; i < this.id.length; ++i) {
            if (allNull && this.id[i] != 0) {
                allNull = false;
            }
            if (this.id[i] != nodeId.id[i]) {
                for (int j = 0; j < BITS.length && (this.id[i] & BITS[j]) == (nodeId.id[i] & BITS[j]); ++j) {
                    ++bitIndex;
                }
                break;
            }
            bitIndex += BITS.length;
        }
        if (allNull) {
            return -1;
        }
        if (bitIndex == 160) {
            return -2;
        }
        return bitIndex;
    }

    public KUID xor(KUID nodeId) {
        byte[] result = new byte[this.id.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(this.id[i] ^ nodeId.id[i]);
        }
        return new KUID(result);
    }

    public KUID invert() {
        byte[] result = new byte[this.id.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ~this.id[i];
        }
        return new KUID(result);
    }

    public boolean isNearerTo(KUID targetId, KUID otherId) {
        int xorToSelf = 0;
        int xorToOther = 0;
        for (int i = 0; i < this.id.length; ++i) {
            xorToSelf = (this.id[i] ^ targetId.id[i]) & 0xFF;
            xorToOther = (otherId.id[i] ^ targetId.id[i]) & 0xFF;
            if (xorToSelf < xorToOther) {
                return true;
            }
            if (xorToSelf <= xorToOther) continue;
            return false;
        }
        return false;
    }

    public byte[] getBytes() {
        return this.getBytes(0, new byte[this.id.length], 0, this.id.length);
    }

    public byte[] getBytes(int srcPos, byte[] dest, int destPos, int length) {
        System.arraycopy(this.id, srcPos, dest, destPos, length);
        return dest;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(KUID o) {
        int d = 0;
        for (int i = 0; i < this.id.length; ++i) {
            d = (this.id[i] & 0xFF) - (o.id[i] & 0xFF);
            if (d < 0) {
                return -1;
            }
            if (d <= 0) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KUID)) {
            return false;
        }
        return Arrays.equals(this.id, ((KUID)o).id);
    }

    public String toHexString() {
        return ArrayUtils.toHexString(this.id);
    }

    public String toBinString() {
        return ArrayUtils.toBinString(this.id);
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.id);
    }

    public int log2() {
        return this.toBigInteger().bitLength();
    }

    public String toString() {
        return this.toHexString();
    }

    public static KUID createRandomID() {
        MessageDigestInput randomNumbers = new MessageDigestInput(){

            public void update(MessageDigest md) {
                byte[] random = new byte[40];
                GENERATOR.nextBytes(random);
                md.update(random);
            }
        };
        MessageDigestInput properties = new MessageDigestInput(){

            public void update(MessageDigest md) {
                Properties props = System.getProperties();
                try {
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        md.update(key.getBytes("UTF-8"));
                        md.update(value.getBytes("UTF-8"));
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        MessageDigestInput millis = new MessageDigestInput(){

            public void update(MessageDigest md) {
                long millis = System.currentTimeMillis();
                md.update((byte)(millis >> 56 & 0xFFL));
                md.update((byte)(millis >> 48 & 0xFFL));
                md.update((byte)(millis >> 40 & 0xFFL));
                md.update((byte)(millis >> 32 & 0xFFL));
                md.update((byte)(millis >> 24 & 0xFFL));
                md.update((byte)(millis >> 16 & 0xFFL));
                md.update((byte)(millis >> 8 & 0xFFL));
                md.update((byte)(millis & 0xFFL));
            }
        };
        MessageDigestInput nanos = new MessageDigestInput(){

            public void update(MessageDigest md) {
                long nanos = System.nanoTime();
                md.update((byte)(nanos >> 56 & 0xFFL));
                md.update((byte)(nanos >> 48 & 0xFFL));
                md.update((byte)(nanos >> 40 & 0xFFL));
                md.update((byte)(nanos >> 32 & 0xFFL));
                md.update((byte)(nanos >> 24 & 0xFFL));
                md.update((byte)(nanos >> 16 & 0xFFL));
                md.update((byte)(nanos >> 8 & 0xFFL));
                md.update((byte)(nanos & 0xFFL));
            }
        };
        Object[] input = new MessageDigestInput[]{properties, randomNumbers, millis, nanos};
        Arrays.sort(input);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            for (Object mdi : input) {
                ((MessageDigestInput)mdi).update(md);
                int hashCode = System.identityHashCode(mdi);
                md.update((byte)(hashCode >> 24 & 0xFF));
                md.update((byte)(hashCode >> 16 & 0xFF));
                md.update((byte)(hashCode >> 8 & 0xFF));
                md.update((byte)(hashCode & 0xFF));
                md.update((byte)(((MessageDigestInput)mdi).rnd >> 24 & 0xFF));
                md.update((byte)(((MessageDigestInput)mdi).rnd >> 16 & 0xFF));
                md.update((byte)(((MessageDigestInput)mdi).rnd >> 8 & 0xFF));
                md.update((byte)(((MessageDigestInput)mdi).rnd & 0xFF));
            }
            return new KUID(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static KUID createWithBytes(byte[] id) {
        byte[] dst = new byte[id.length];
        System.arraycopy(id, 0, dst, 0, id.length);
        return new KUID(dst);
    }

    public static KUID createWithHexString(String id) {
        return new KUID(ArrayUtils.parseHexString(id));
    }

    public static KUID createWithInputStream(InputStream in) throws IOException {
        byte[] id = new byte[20];
        int len = -1;
        for (int r = 0; r < id.length; r += len) {
            len = in.read(id, r, id.length - r);
            if (len >= 0) continue;
            throw new EOFException();
        }
        return new KUID(id);
    }

    public static KUID createPrefxNodeID(KUID prefix, int depth) {
        byte[] random = new byte[20];
        GENERATOR.nextBytes(random);
        return KUID.createPrefxNodeID(prefix, depth, random);
    }

    private static KUID createPrefxNodeID(KUID prefix, int depth, byte[] random) {
        int length = ++depth / 8;
        System.arraycopy(prefix.id, 0, random, 0, length);
        int bitsToCopy = depth % 8;
        if (bitsToCopy != 0) {
            int mask = (1 << 8 - bitsToCopy) - 1;
            byte prefixByte = prefix.id[length];
            byte randByte = random[length];
            random[length] = (byte)(prefixByte & ~mask | randByte & mask);
        }
        return new KUID(random);
    }

    static {
        byte[] min = new byte[20];
        byte[] max = new byte[20];
        Arrays.fill(max, (byte)-1);
        MINIMUM = new KUID(min);
        MAXIMUM = new KUID(max);
        KEY_ANALYZER = new KUIDKeyAnalyzer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KUIDKeyAnalyzer
    implements PatriciaTrie.KeyAnalyzer<KUID> {
        private static final long serialVersionUID = 6412279289438108492L;

        private KUIDKeyAnalyzer() {
        }

        @Override
        public int bitIndex(KUID key, int keyStart, int keyLength, KUID found, int foundStart, int foundLength) {
            if (found == null) {
                found = MINIMUM;
            }
            return key.bitIndex(found);
        }

        @Override
        public int bitsPerElement() {
            return 1;
        }

        @Override
        public boolean isBitSet(KUID key, int keyLength, int bitIndex) {
            return key.isBitSet(bitIndex);
        }

        @Override
        public boolean isPrefix(KUID prefix, int offset, int length, KUID key) {
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                if (prefix.isBitSet(i) == key.isBitSet(i)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int length(KUID key) {
            return 20;
        }

        @Override
        public int compare(KUID o1, KUID o2) {
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MessageDigestInput
    implements Comparable<MessageDigestInput> {
        private int rnd = KUID.access$100().nextInt();

        private MessageDigestInput() {
        }

        public abstract void update(MessageDigest var1);

        @Override
        public int compareTo(MessageDigestInput o) {
            return this.rnd - o.rnd;
        }
    }
}

