/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.concurrent;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.mojito.concurrent.Cancellable;
import org.limewire.mojito.concurrent.DHTExecutorService;
import org.limewire.mojito.concurrent.DefaultThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDHTExecutorService
implements DHTExecutorService {
    private volatile ThreadFactory threadFactory;
    private ScheduledExecutorService scheduledExecutor;
    private ExecutorService cachedExecutor;
    private ExecutorService sequentialExecutor;
    private final String name;
    private volatile boolean running = false;

    public DefaultDHTExecutorService(String name) {
        this.name = name;
        this.threadFactory = new DefaultThreadFactory(name);
    }

    @Override
    public void start() {
        if (!this.running) {
            this.initScheduledExecutor();
            this.initCachedExecutor();
            this.initSequantialExecutor();
            this.running = true;
        }
    }

    @Override
    public void stop() {
        if (this.running) {
            this.running = false;
            this.cancel(this.scheduledExecutor.shutdownNow());
            this.cancel(this.cachedExecutor.shutdownNow());
            this.cancel(this.sequentialExecutor.shutdownNow());
        }
    }

    private void cancel(Collection<?> c) {
        for (Object o : c) {
            if (!(o instanceof Cancellable)) continue;
            ((Cancellable)o).cancel(true);
        }
    }

    private void initScheduledExecutor() {
        ThreadFactory factory = new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = DefaultDHTExecutorService.this.getThreadFactory().newThread(r);
                thread.setName(DefaultDHTExecutorService.this.name + "-ContextScheduledThreadPool");
                thread.setDaemon(true);
                return thread;
            }
        };
        this.scheduledExecutor = Executors.newScheduledThreadPool(1, factory);
    }

    private void initCachedExecutor() {
        ThreadFactory factory = new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = DefaultDHTExecutorService.this.getThreadFactory().newThread(r);
                thread.setName(DefaultDHTExecutorService.this.name + "-ContextCachedThreadPool");
                thread.setDaemon(true);
                return thread;
            }
        };
        this.cachedExecutor = ExecutorsHelper.newThreadPool(factory);
    }

    private void initSequantialExecutor() {
        this.sequentialExecutor = ExecutorsHelper.newProcessingQueue("DHT-Sequential-Executor");
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long delay, long period, TimeUnit unit) {
        return this.scheduledExecutor.scheduleAtFixedRate(command, delay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduledExecutor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule(task, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule(command, delay, unit);
    }

    @Override
    public <V> Future<V> submit(Callable<V> task) {
        return this.cachedExecutor.submit(task);
    }

    @Override
    public void execute(Runnable command) {
        if (this.running) {
            this.cachedExecutor.execute(command);
        }
    }

    @Override
    public void executeSequentially(Runnable command) {
        if (this.running) {
            this.sequentialExecutor.execute(command);
        }
    }
}

