/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedDHTFuture<T>
implements DHTFuture<T> {
    private final OnewayExchanger<T, ExecutionException> exchanger = new OnewayExchanger(true);

    public FixedDHTFuture(T value) {
        this.exchanger.setValue(value);
    }

    public FixedDHTFuture(Exception exception) {
        this.exchanger.setException(new ExecutionException(exception));
    }

    @Override
    public void addDHTFutureListener(DHTFutureListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("DHTFutureListener is null");
        }
        try {
            T value = this.get();
            listener.handleFutureSuccess(value);
        }
        catch (ExecutionException e) {
            listener.handleExecutionException(e);
        }
        catch (CancellationException e) {
            listener.handleCancellationException(e);
        }
        catch (InterruptedException e) {
            listener.handleInterruptedException(e);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.exchanger.cancel();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.exchanger.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.exchanger.get(timeout, unit);
    }

    @Override
    public boolean isCancelled() {
        return this.exchanger.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.exchanger.isDone();
    }
}

