/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import java.io.Serializable;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.Storable;
import org.limewire.mojito.routing.Contact;

public class DHTValueEntity
implements Serializable {
    private static final long serialVersionUID = 2007158043378144871L;
    private final Contact creator;
    private final Contact sender;
    private final KUID primaryKey;
    private final KUID secondaryKey;
    private final DHTValue value;
    private final long creationTime = System.currentTimeMillis();
    private final boolean local;
    private final int hashCode;

    public static DHTValueEntity createFromStorable(MojitoDHT mojitoDHT, Storable storable) {
        return new DHTValueEntity(mojitoDHT.getLocalNode(), mojitoDHT.getLocalNode(), storable.getPrimaryKey(), storable.getValue(), true);
    }

    public static DHTValueEntity createFromValue(MojitoDHT mojitoDHT, KUID primaryKey, DHTValue value) {
        return new DHTValueEntity(mojitoDHT.getLocalNode(), mojitoDHT.getLocalNode(), primaryKey, value, true);
    }

    public static DHTValueEntity createFromRemote(Contact creator, Contact sender, KUID primaryKey, DHTValue value) {
        return new DHTValueEntity(creator, sender, primaryKey, value, false);
    }

    DHTValueEntity(Contact creator, Contact sender, KUID primaryKey, DHTValue value, boolean local) {
        this.creator = creator;
        this.sender = sender;
        this.primaryKey = primaryKey;
        this.secondaryKey = creator.getNodeID();
        this.value = value;
        this.local = local;
        this.hashCode = 17 * primaryKey.hashCode() + this.secondaryKey.hashCode();
    }

    public Contact getCreator() {
        return this.creator;
    }

    public Contact getSender() {
        return this.sender;
    }

    public KUID getPrimaryKey() {
        return this.primaryKey;
    }

    public KUID getSecondaryKey() {
        return this.secondaryKey;
    }

    public DHTValue getValue() {
        return this.value;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public boolean isDirect() {
        return this.creator.equals(this.sender);
    }

    public boolean isLocalValue() {
        return this.local;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DHTValueEntity)) {
            return false;
        }
        DHTValueEntity other = (DHTValueEntity)o;
        return this.primaryKey.equals(other.getPrimaryKey()) && this.secondaryKey.equals(other.getSecondaryKey());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Creator: ").append(this.getCreator()).append("\n");
        buffer.append("Sender: ").append(this.getSender()).append("\n");
        buffer.append("Primary Key: ").append(this.getPrimaryKey()).append("\n");
        buffer.append("Secondary Key: ").append(this.getSecondaryKey()).append("\n");
        buffer.append("Creation time: ").append(this.getCreationTime()).append("\n");
        buffer.append("---\n").append(this.getValue()).append("\n");
        return buffer.toString();
    }
}

