/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.db.Storable;
import org.limewire.mojito.db.StorableModel;
import org.limewire.mojito.result.StoreResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorableModelManager {
    private static final Log LOG = LogFactory.getLog(StorableModelManager.class);
    private final Map<DHTValueType, StorableModel> models = Collections.synchronizedMap(new HashMap());

    public StorableModel addStorableModel(DHTValueType valueType, StorableModel model) {
        if (valueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        if (model == null) {
            throw new NullPointerException("StorableModel is null");
        }
        return this.models.put(valueType, model);
    }

    public StorableModel removeStorableModel(DHTValueType valueType) {
        if (valueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        return this.models.remove(valueType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Storable> getStorables() {
        ArrayList<Storable> values = new ArrayList<Storable>();
        Map<DHTValueType, StorableModel> map = this.models;
        synchronized (map) {
            block3: for (StorableModel model : this.models.values()) {
                Collection<Storable> storables = model.getStorables();
                if (storables == null) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error(model + " returned a null Collection");
                    continue;
                }
                for (Storable storable : storables) {
                    if (storable == null) {
                        if (!LOG.isErrorEnabled() || !LOG.isErrorEnabled()) continue block3;
                        LOG.error(model + " returned a Collection with a null element");
                        continue block3;
                    }
                    values.add(storable);
                }
            }
        }
        return values;
    }

    void handleStoreResult(Storable value, StoreResult result) {
        DHTValueType type = value.getValue().getValueType();
        StorableModel model = this.models.get(type);
        if (model != null) {
            model.handleStoreResult(value, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleContactChange(Context context) {
        Map<DHTValueType, StorableModel> map = this.models;
        synchronized (map) {
            for (StorableModel model : this.models.values()) {
                model.handleContactChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Map<DHTValueType, StorableModel> map = this.models;
        synchronized (map) {
            for (DHTValueType type : this.models.keySet()) {
                StorableModel model = this.models.get(type);
                buffer.append(type).append(":\n");
                buffer.append(model).append("\n\n");
            }
        }
        return buffer.toString();
    }
}

