/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.util.ArrayUtils;

public class DHTValueImpl
implements DHTValue {
    private static final long serialVersionUID = -7381830963268622187L;
    private static final byte[] EMPTY = new byte[0];
    private final DHTValueType valueType;
    private final Version version;
    private final byte[] value;
    private final int hashCode;

    public DHTValueImpl(DHTValueType valueType, Version version, byte[] value) {
        this.valueType = valueType;
        this.version = version;
        if (value == null || value.length == 0) {
            value = EMPTY;
        }
        this.value = value;
        this.hashCode = Arrays.hashCode(value);
    }

    public DHTValueType getValueType() {
        return this.valueType;
    }

    public Version getVersion() {
        return this.version;
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.value, 0, this.value.length);
    }

    public byte[] getValue() {
        byte[] copy = new byte[this.value.length];
        System.arraycopy(this.value, 0, copy, 0, this.value.length);
        return copy;
    }

    public int size() {
        return this.value.length;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DHTValue)) {
            return false;
        }
        DHTValue other = (DHTValue)o;
        return this.valueType.equals(other.getValueType()) && this.version.equals(other.getVersion()) && Arrays.equals(this.value, other.getValue());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DHTValueType: ").append(this.getValueType()).append("\n");
        buffer.append("Version: ").append(this.getVersion()).append("\n");
        buffer.append("Value: ");
        if (this.size() == 0) {
            buffer.append("This is an empty value (REMOVE operation)");
        } else {
            try {
                if (this.valueType.equals(DHTValueType.TEXT) || this.valueType.equals(DHTValueType.TEST)) {
                    buffer.append(new String(this.getValue(), "UTF-8")).append("\n");
                } else {
                    buffer.append(ArrayUtils.toHexString(this.getValue())).append("\n");
                }
            }
            catch (UnsupportedEncodingException err) {
                throw new RuntimeException(err);
            }
        }
        return buffer.toString();
    }
}

