/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db.impl;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntHashMap;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.db.DatabaseSecurityConstraint;
import org.limewire.mojito.db.impl.DHTValueEntityBag;
import org.limewire.mojito.db.impl.DefaultDatabaseSecurityConstraint;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.DatabaseSettings;
import org.limewire.mojito.util.ContactUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseImpl
implements Database {
    private static final long serialVersionUID = -4857315774747734947L;
    private static final Log LOG = LogFactory.getLog(DatabaseImpl.class);
    public static final int IPV4_ADDRESS_NETMASK = -1;
    private final Map<KUID, DHTValueEntityBag> database = new HashMap<KUID, DHTValueEntityBag>();
    private volatile DatabaseSecurityConstraint securityConstraint = new DefaultDatabaseSecurityConstraint();
    private final IntHashMap<AtomicInteger> valuesPerNetwork = new IntHashMap();
    private final IntHashMap<AtomicInteger> valuesPerAddress = new IntHashMap();

    @Override
    public void setDatabaseSecurityConstraint(DatabaseSecurityConstraint securityConstraint) {
        if (securityConstraint == null) {
            securityConstraint = new DefaultDatabaseSecurityConstraint();
        }
        this.securityConstraint = securityConstraint;
    }

    @Override
    public synchronized int getKeyCount() {
        return this.database.size();
    }

    @Override
    public synchronized int getValueCount() {
        return this.values().size();
    }

    @Override
    public synchronized void clear() {
        this.database.clear();
    }

    @Override
    public synchronized boolean store(DHTValueEntity entity) {
        if (!this.allowStore(entity)) {
            return false;
        }
        if (entity.getValue().size() == 0) {
            return this.remove(entity.getPrimaryKey(), entity.getSecondaryKey()) != null;
        }
        return this.add(entity);
    }

    public synchronized boolean add(DHTValueEntity entity) {
        KUID primaryKey = entity.getPrimaryKey();
        DHTValueEntityBag bag = this.database.get(primaryKey);
        if (bag == null) {
            bag = new DHTValueEntityBag(this, primaryKey);
        }
        if (bag.add(entity)) {
            if (!this.database.containsKey(primaryKey)) {
                this.database.put(primaryKey, bag);
            }
            this.incrementValuesPerAddress(entity);
            this.incrementValuesPerNetwork(entity);
            return true;
        }
        return false;
    }

    @Override
    public synchronized DHTValueEntity remove(KUID primaryKey, KUID secondaryKey) {
        DHTValueEntity entity = null;
        DHTValueEntityBag bag = this.database.get(primaryKey);
        if (bag != null && (entity = bag.remove(secondaryKey)) != null) {
            if (bag.isEmpty()) {
                this.database.remove(primaryKey);
            }
            this.decrementValuesPerAddress(entity);
            this.decrementValuesPerNetwork(entity);
        }
        return entity;
    }

    public synchronized int getValuesPerNetwork(DHTValueEntity entity) {
        return DatabaseImpl.getValueCount(entity, this.valuesPerNetwork, -256);
    }

    public synchronized int getValuesPerAddress(DHTValueEntity entity) {
        return DatabaseImpl.getValueCount(entity, this.valuesPerAddress, -1);
    }

    private static int getValueCount(DHTValueEntity entity, IntHashMap<AtomicInteger> map, int netmask) {
        int masked;
        AtomicInteger count;
        if (entity.isLocalValue()) {
            return 0;
        }
        Contact node = entity.getCreator();
        InetAddress addr = ((InetSocketAddress)node.getContactAddress()).getAddress();
        if (addr instanceof Inet4Address && (count = map.get(masked = NetworkUtils.getMaskedIP(addr, netmask))) != null) {
            return count.get();
        }
        return 0;
    }

    private int incrementValuesPerNetwork(DHTValueEntity entity) {
        return DatabaseImpl.incrementValueCount(entity, this.valuesPerNetwork, -256);
    }

    private int incrementValuesPerAddress(DHTValueEntity entity) {
        return DatabaseImpl.incrementValueCount(entity, this.valuesPerAddress, -1);
    }

    private static int incrementValueCount(DHTValueEntity entity, IntHashMap<AtomicInteger> map, int netmask) {
        if (entity.isLocalValue()) {
            return 0;
        }
        Contact node = entity.getCreator();
        InetAddress addr = ((InetSocketAddress)node.getContactAddress()).getAddress();
        if (addr instanceof Inet4Address) {
            int masked = NetworkUtils.getMaskedIP(addr, netmask);
            AtomicInteger count = map.get(masked);
            if (count == null) {
                count = new AtomicInteger(0);
                map.put(masked, count);
            }
            return count.incrementAndGet();
        }
        return 0;
    }

    private int decrementValuesPerNetwork(DHTValueEntity entity) {
        return DatabaseImpl.decrementValueCount(entity, this.valuesPerNetwork, -256);
    }

    private int decrementValuesPerAddress(DHTValueEntity entity) {
        return DatabaseImpl.decrementValueCount(entity, this.valuesPerAddress, -1);
    }

    private static int decrementValueCount(DHTValueEntity entity, IntHashMap<AtomicInteger> map, int netmask) {
        int masked;
        AtomicInteger count;
        if (entity.isLocalValue()) {
            return 0;
        }
        Contact node = entity.getCreator();
        InetAddress addr = ((InetSocketAddress)node.getContactAddress()).getAddress();
        if (addr instanceof Inet4Address && (count = map.get(masked = NetworkUtils.getMaskedIP(addr, netmask))) != null) {
            int value = count.decrementAndGet();
            if (value == 0) {
                map.remove(masked);
            }
            return value;
        }
        return 0;
    }

    @Override
    public synchronized float getRequestLoad(KUID primaryKey, boolean incrementLoad) {
        DHTValueEntityBag bag = this.database.get(primaryKey);
        if (bag != null) {
            return bag.getRequestLoad(incrementLoad);
        }
        return 0.0f;
    }

    private boolean allowStore(DHTValueEntity entity) {
        if (entity.isLocalValue()) {
            return true;
        }
        if (DatabaseSettings.VALIDATE_VALUE_CREATOR.getValue() && !entity.isDirect()) {
            if (!ContactUtils.isValidSocketAddress(entity.getCreator())) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("The Creator of " + entity + " has an invalid address");
                }
                return false;
            }
            if (ContactUtils.isPrivateAddress(entity.getCreator())) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("The Creator of " + entity + " has a private address");
                }
                return false;
            }
        }
        if (entity.getValue().size() != 0) {
            int valuesPerAddress = this.getValuesPerAddress(entity);
            if (DatabaseSettings.LIMIT_VALUES_PER_ADDRESS.getValue() && valuesPerAddress >= DatabaseSettings.MAX_VALUES_PER_ADDRESS.getValue()) {
                return false;
            }
            int valuesPerNetwork = this.getValuesPerNetwork(entity);
            if (DatabaseSettings.LIMIT_VALUES_PER_NETWORK.getValue() && valuesPerNetwork >= DatabaseSettings.MAX_VALUES_PER_NETWORK.getValue()) {
                return false;
            }
        }
        DHTValueEntityBag bag = this.database.get(entity.getPrimaryKey());
        DatabaseSecurityConstraint dbsc = this.securityConstraint;
        if (dbsc != null && bag != null) {
            return dbsc.allowStore(this, bag.getValues(false), entity);
        }
        return true;
    }

    public synchronized DHTValueEntityBag getBag(KUID valueId) {
        return this.database.get(valueId);
    }

    @Override
    public synchronized Map<KUID, DHTValueEntity> get(KUID valueId) {
        DHTValueEntityBag bag = this.database.get(valueId);
        if (bag != null) {
            return bag.getValues(true);
        }
        return Collections.emptyMap();
    }

    @Override
    public synchronized boolean contains(KUID primaryKey, KUID secondaryKey) {
        DHTValueEntityBag bag = this.database.get(primaryKey);
        return bag != null && bag.contains(secondaryKey);
    }

    @Override
    public synchronized Set<KUID> keySet() {
        return new HashSet<KUID>(this.database.keySet());
    }

    @Override
    public synchronized Collection<DHTValueEntity> values() {
        ArrayList<DHTValueEntity> values = new ArrayList<DHTValueEntity>(this.getKeyCount() * 2);
        for (DHTValueEntityBag bag : this.database.values()) {
            values.addAll(bag.getValues(false).values());
        }
        return values;
    }

    public synchronized String toString() {
        StringBuilder buffer = new StringBuilder();
        for (DHTValueEntityBag bag : this.database.values()) {
            buffer.append(bag.toString());
        }
        buffer.append("-------------\n");
        buffer.append("TOTAL: ").append(this.getKeyCount()).append("/").append(this.getValueCount()).append("\n");
        return buffer.toString();
    }
}

